<?php

/**
 * Plugin Name: WordPress Social Board
 * Plugin URI: http://axentmedia.com/wordpress-social-board/
 * Description: Combine all your social media network & feed updates (Facebook, Twitter, Google+, Flickr, YouTube, RSS, ...) into one feed and display on your website.
 * Tags: social stream, wordpress social plugin, social feed, social tabs, social wall, social timeline, social media, social networks, feed reader, facebook, twitter, google+, tumblr, delicious, pinterest, flickr, instagram, youtube, vimeo, stumbleupon, deviantart, rss, soundcloud, vk
 * Version: 2.5
 * Author: Axent Media
 * Author URI: http://axentmedia.com/
 * License: http://codecanyon.net/licenses/standard
 * 
 * Copyright 2014 Axent Media (axentmedia@gmail.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Define constants for the demo plugin - these are not necessary in your project
define( 'SB_VERSION', '2.5' );
define( 'SB_DOCS', 'http://axentmedia.com/wordpress-social-board-docs/' );
define( 'SB_FILE', __FILE__ );
define( 'SB_DIRNAME', dirname( SB_FILE ) );
define( 'SB_LOGFILE', SB_DIRNAME.'/sb.log' );

session_start();

// Localization
load_plugin_textdomain(
    'social-board',
    false,  // deprecated
    basename( SB_DIRNAME ) . '/language/'  // Relative path to WP_PLUGIN_DIR where the .mo file resides.
);

// Include the library file
if ( ! class_exists( 'SB_AdminPageFramework' ) ) {
    include( SB_DIRNAME . '/library/admin-page-framework/admin-page-framework.php' );
}
include( SB_DIRNAME . '/admin/SB_Bootstrap.php' );

// Social Board main class
class SocialBoard {
    public $attr;
    public $echo = true;
    public $args = null;
    
    public function __construct() {
        
        add_action( 'wp_head', array(&$this, 'header') );
        add_action( 'wp_enqueue_scripts', array(&$this, 'add_styles') );
        
        // Add Shortcode
        add_shortcode( 'social_board', array('SocialBoard', 'social_board_shortcode') );
    }
    
    // Initialize by property
    function run(){
        $this->init( $this->attr, $this->echo, $this->args );
    }

    // Initialize by function
    function init( $attr, $echo = true, $args = null, $ajax_feed = array(), $loadmore = array() ) {
        
        $id = (@$attr['network']) ? uniqid() : $attr['id'];
        $this->sboption = (@$attr['network']) ? $attr['network'] : sb_options( $id );
        $type = $attr['type'];
        
        // get default setting & post options
        $defoption = array(
            'setting' => array(
                'theme' => 'sb-modern-light',
                'results' => '30',
                'words' => '40',
                'commentwords' => '20',
                'titles' => '15',
                'userinfo' => 'top',
                'readmore' => '1',
                'order' => 'date',
                'filters' => '1',
                'loadmore' => '1',
                'links' => '1',
                'nofollow' => '1',
                'cache' => '360',
                'crawl' => '10',
                'timeout' => '15',
                'debuglog' => '0'
            ),
            'wallsetting' => array(
                'animate' => 'true',
                'delay' => '0',
                'filter_direction' => 'false',
                'itemwidth' => '230',
                'fixSize' => '1'
            ),
            'feedsetting' => array(
                'rotate_speed' => '100',
                'duration' => '4000',
                'direction' => 'up',
                'controls' => '1',
                'autostart' => '1',
                'pauseonhover' => '1',
                'width' => '250'
            ),
            'carouselsetting' => array(
                'cs_speed' => '400',
                'autoWidth'=> 'false',
                'cs_item' => array('4', '3', '2', '2', '1'),
                'cs_width' => '230',
                'cs_rtl' => 'false',
                'cs_controls' => 'true',
                'cs_auto' => 'false',
                'cs_loop' => 'true',
                'cs_pager' => 'true',
                'slideMargin' => '10',
                'slideMove' => '1'
            ),
            'timelinesetting' => array(
                'onecolumn' => 'false'
            )
        );
        
        // merge options
        $setoption = SB_AdminPageFramework::getOption( 'SB_Settings_Page' );
        $setoption = array_merge($defoption, $setoption);
        foreach ($defoption as $defoptKey => $defoptVal) {
            if ( isset($setoption[$defoptKey]) )
                $setoption[$defoptKey] = array_merge($defoptVal, $setoption[$defoptKey]);
        }
        
    	// the array of feeds to get
        $filters_order = array( 'facebook', 'twitter', 'google', 'tumblr', 'delicious', 'pinterest', 'flickr', 'instagram', 'youtube', 'vimeo', 'stumbleupon', 'deviantart', 'rss', 'soundcloud', 'vk' );
    	$this->feed_keys = ( ! empty($ajax_feed) && $ajax_feed != 'all' ) ? $ajax_feed : (@$setoption['setting']['filters_order'] ? $setoption['setting']['filters_order'] : $filters_order);
        
        // define theme
        if ( ! $theme = @$attr['theme'] )
            $theme = $setoption['setting']['theme'];
        $themeoption = sb_options( $theme );

        // set some settings
        $label = (@$args['widget_id']) ? $args['widget_id'] : $type.$id;
        if ( $type == 'feed' ) {
            $is_feed = true;
            $settingsection = (@$attr['carousel']) ? 'carouselsetting' : 'feedsetting';
            $filterlabel = '';
        } else {
            $is_feed = false;
            $settingsection = $type.'setting';
            $filterlabel = ' filter-label';
        }
        $is_timeline = ( $type == 'timeline' ) ? true : false;
        $is_wall = ( $type == 'wall' ) ? true : false;

        $typeoption = $type;
        if ( $is_feed ) {
            if ( @$attr['position'] ){
                if ( @$attr['position'] != 'normal' )
                    $typeoption = 'feed_sticky';
            }
            if (@$attr['carousel'])
                $typeoption = 'feed_carousel';
        }

        // main container id
        if ( @$label )
            $attr_id = ' id="timeline_'.$label.'"';
        $class = array('sboard');

        // merge shortcode and widget attributes with related default settings
        if ( ! @$setoption[$settingsection] )
            $setoption[$settingsection] = array();
        $this->attr = $attr = array_merge($setoption['setting'], $setoption[$settingsection], $attr);
        
        // set results
        if ( ! $results = @$attr['results'] )
    		$results = 10;
    	if (@$args['liveresults'])
        if ( $results < $args['liveresults'] )
            $results = $args['liveresults'];
        if ( $results > 100 )
            $results = 100;
        $attr['results'] = $results;
        
        $attr_ajax = json_encode($attr);
        $attr['cache'] = (int)$attr['cache'];

        // set crawl time limit (some servers can not read a lot of feeds at the same time)
        $GLOBALS['crawled'] = 0;
        $crawl_limit = ($attr['cache'] == 0) ? 0 : (int)@$attr['crawl'];
        
        // Init cache
        $cache = new SimpleCache;
        $cache->debug_log = @$attr['debuglog'];
        $cache->timeout = @$attr['timeout'];
        
        // add some js files
        if ( $is_timeline ) {
            wp_enqueue_script( 'timeline', plugins_url( 'public/js/timeline.js', SB_FILE ), array('jquery'), false, true);
        } else {
            if ( $is_feed ) {
                if (@$attr['carousel'])
                    wp_enqueue_script( 'lightslider', plugins_url( 'public/js/lightslider.min.js', SB_FILE ), array('jquery'), false, true);
                else
                    wp_register_script( 'newsticker', plugins_url( 'public/js/jquery.newsTicker.min.js', SB_FILE ), array('jquery'), false, true);
            } else {
                wp_enqueue_script( 'freewall', plugins_url( 'public/js/freewall.min.js', SB_FILE ), array('jquery'), false, true);
            }
        }
        
        if ( $is_feed ) {
            if (@$attr['carousel']){
                $class[] = 'sb-carousel';
                if (@$args['widget_id'])
                    $class[] = 'sb-widget';
            } else {
                $class[] = 'sb-widget';
                wp_enqueue_script( 'newsticker' );
            }
        } elseif ($is_wall) {
            $class[] = 'sb-wall';
        }

        // set the block height
        $block_height = (@$attr['height']) ? $attr['height'] : 400;

        // load layout
        include_once( SB_DIRNAME . '/layout/'.$themeoption['layout'].'.php' );
        if ( $themeoption['classname'] != $themeoption['layout'])
            $class[] = 'sb-'.$themeoption['layout'];

        $layoutclass = $themeoption['layout'].'Layout';
        $layoutobj = new $layoutclass;
        
        if ( ! $ajax_feed) {
        // do some styling stuffs
        $dotboard = "#timeline_$label.sboard";
        if ( @$themeoption['social_colors'] ) {
            $style = $layoutobj->sb_create_colors( $themeoption['social_colors'], $filters_order, $type, $dotboard, $attr, @$themeoption["section_$typeoption"] );
            
            foreach ($themeoption['social_colors'] as $colorKey => $colorVal) {
                if (@$colorVal && @$colorVal != 'transparent') {
                }
            }
        }
        
        if ($is_wall) {
            if (@$attr['itemwidth']) {
                $dotitem2 = '.sb-item';
                $itemwidth = $attr['itemwidth'];
            }
        } else {
            if (@$attr['carousel']) {
                if (@$attr['cs_width']) {
                    $dotitem2 = '.lslide';
                    $itemwidth = $attr['cs_width'];
                }
            }
        }
        if (@$itemwidth)
            $style["$dotboard $dotitem2"][] = 'width: '.$itemwidth.'px;';
        
        if ( $font_size = @$themeoption['font_size'] ) {
            $style["$dotboard, $dotboard a"][] = 'font-size: '.$font_size.'px';
            $style["$dotboard .sb-heading"][] = 'font-size: '.($font_size+1).'px !important';
        }
        
        if ( $is_feed && @$themeoption["section_$typeoption"]['title_background_color'] )
        if ( $themeoption["section_$typeoption"]['title_background_color'] != 'transparent') {
            $style["$dotboard .sb-heading, $dotboard .sb-opener"][] = 'background-color: '.$themeoption["section_$typeoption"]['title_background_color'].' !important';
        }
        if ( $is_feed && @$themeoption["section_$typeoption"]['title_color'] )
        if ( $themeoption["section_$typeoption"]['title_color'] != 'transparent')
            $style["$dotboard .sb-heading"][] = 'color: '.$themeoption["section_$typeoption"]['title_color'];
        
        if ( $is_feed )
            $csskey = "$dotboard .sb-content, $dotboard .toolbar";
        else
            $csskey = '#sb_'.$label;
            
        if ( @$themeoption["section_$typeoption"]['background_color'] ) {
            if ( $themeoption["section_$typeoption"]['background_color'] != 'transparent') {
                $bgexist = true;
                $style[$csskey][] = 'background-color: '.$themeoption["section_$typeoption"]['background_color'];
            }
        }
        
        if ( $is_timeline )
            $fontcsskey = "$dotboard .timeline-row";
        else
            $fontcsskey = "$dotboard .sb-item";
            
        if (@$themeoption["section_$typeoption"]['font_color'])
        if ($themeoption["section_$typeoption"]['font_color'] != 'transparent') {
            $rgbColorVal = sb_hex2rgb($themeoption["section_$typeoption"]['font_color']); // returns the rgb values separated by commas
            
            if ( $is_timeline ) {
                $style["$dotboard .timeline-row small"][] = 'color: '.$themeoption["section_$typeoption"]['font_color'];
            }
            
            $style["$fontcsskey .sb-title a"][] = 'color: '.$themeoption["section_$typeoption"]['font_color'];
            $style["$fontcsskey"][] = 'color: rgba('.$rgbColorVal.', 0.8)';
        }
        if (@$themeoption["section_$typeoption"]['link_color'])
        if ($themeoption["section_$typeoption"]['link_color'] != 'transparent') {
            $rgbColorVal = sb_hex2rgb($themeoption["section_$typeoption"]['link_color']); // returns the rgb values separated by commas
            $style["$fontcsskey a"][] = 'color: '.$themeoption["section_$typeoption"]['link_color'];
            $style["$fontcsskey a:visited"][] = 'color: rgba('.$rgbColorVal.', 0.8)';
        }

        if ( @$themeoption["section_$typeoption"]['background_image'] ) {
            $bgexist = true;
            $cssbgkey = $csskey;
            if ( $is_feed )
                $cssbgkey = "$dotboard .sb-content";
            $style[$cssbgkey][] = 'background-image: url('.$themeoption["section_$typeoption"]['background_image'].');background-repeat: repeat';
        }

        $location = null;
        if ( $is_feed ) {
            $class[] = @$attr['position'];
            if ( @$attr['position'] != 'normal' ) {
                $class[] = @$attr['location'];
                if ( ! @$attr['autoclose'] ) {
                    $class[] = 'open';
                    $active = ' active';
                }
                
                $locarr = explode('_', str_replace('sb-', '', @$attr['location']) );
                $location = $locarr[0];
            }
        }

        if (@$attr['carousel'] && @$attr['tabable'])
            unset($attr['tabable']);
            
        if (@$attr['tabable'])
            $class[] = 'tabable';
        
        if ( (@$attr['filters'] or @$attr['controls']) && !@$attr['carousel']) {
            $style[$dotboard.' .sb-content'][] = 'border-bottom-left-radius: 0 !important;border-bottom-right-radius: 0 !important';
        }
        if ( (@$attr['showheader'] || ($location == 'bottom' && ! @$attr['tabable']) ) && $is_feed) {
            $style[$dotboard.' .sb-content'][] = 'border-top: 0 !important;border-top-left-radius: 0 !important;border-top-right-radius: 0 !important';
        }
        if ( $location == 'left' )
            $style[$dotboard.' .sb-content'][] = 'border-top-left-radius: 0 !important';
        if ( $location == 'right' )
            $style[$dotboard.' .sb-content'][] = 'border-top-right-radius: 0 !important';
        
    	// set block border
        if ( @$themeoption["section_$typeoption"]['border_color'] ) {
            if ( $themeoption["section_$typeoption"]['border_color'] != 'transparent') {
                $bgexist = true;
                if ( $is_feed ) {
                    $style[$dotboard.' .toolbar'][] = 'border-top: 0 !important';
                }
                $style[$csskey][] = 'border: '.@$themeoption["section_$typeoption"]['border_size'].'px solid '.$themeoption["section_$typeoption"]['border_color'];
            }
        } else {
            if (@$attr['carousel'])
                $style[$dotboard.' .sb-content'][] = 'padding: 10px 0 5px 0;';
        }
        
        // set block padding if required
        if (@$bgexist) {
            $border_radius = @$themeoption["section_$typeoption"]['border_radius'];
            if ( ! $is_feed ) {
                if ($border_radius == '')
                    $border_radius = 7;
            }
            if ($border_radius != '') {
                $radius = 'border-radius: '.$border_radius.'px;-moz-border-radius: '.$border_radius.'px;-webkit-border-radius: '.$border_radius.'px';
                if ( ! $is_feed ) {
                    $style['#sb_'.$label][] = $radius;
                } else {
                    if ($location == 'bottom') {
                        $radius = ': '.$border_radius.'px '.$border_radius.'px 0 0;';
                        $style["$dotboard .sb-content, $dotboard.sb-widget, $dotboard .sb-heading"][] = 'border-radius'.$radius.'-moz-border-radius'.$radius.'-webkit-border-radius'.$radius;
                    } else {
                        $style["$dotboard .sb-content, $dotboard.sb-widget"][] = $radius;
                        $style[$dotboard.' .toolbar'][] = 'border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px;-moz-border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px;-webkit-border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px;';
                    }
                }
            }
            if ( $is_wall )
                $style['#sb_'.$label][] = 'padding: 10px';
        }
        
        if ($is_feed) {
            if (@$attr['width'] != '')
                $style["$dotboard"][] = 'width: '.$attr['width'].'px';
        }
        
        if ( @$attr['height'] != '' && ! $is_feed ) {
            $style[$csskey][] = 'height: '.$attr['height'].'px';
            if ( ! $is_feed ) {
                $style[$csskey][] = 'overflow: scroll';
                if ( $is_timeline )
                    $style[$csskey][] = 'padding-right: 0';
                $style[$dotboard][] = 'padding-bottom: 30px';
            }
        }
        } // end no ajax
        
        if ( @$theme ) {
            $class['theme'] = $themeoption['classname'];
        }
        
    	if ( ! $order = $attr['order'] )
            $order = 'date';
        
        $target = '';
        // nofollow links
        if (@$attr['nofollow'])
            $target .= ' rel="nofollow"';
        
        // open links in new window
        if (@$attr['links'])
            $target .= ' target="_blank"';
        $this->target = $layoutobj->target = $target;
        
        $output = '';
        if ( ! $ajax_feed)
            $output .= "\n<!-- Social Board Plugin By Axent Media -->\t";

    	// Make sure feeds are getting local timestamps
    	if ( get_option( 'timezone_string' ) && strpos( get_option( 'timezone_string' ), 'UTC' ) === false )
    		date_default_timezone_set( get_option( 'timezone_string' ) );

        $GLOBALS['islive'] = false;
        if (@$attr['live']) {
            if (@$attr['live'] == 'users') {
                if ( is_user_logged_in() )
                    $GLOBALS['islive'] = true;
            } elseif (@$attr['live'] == 'all') {
                $GLOBALS['islive'] = true;
            }
        }
        
        if ($GLOBALS['islive']) {
            // Live update need cache to be disabled
            $forceCrawl = true;
        } else {
            // If a cache time is set in the admin AND the "cache" folder is writeable, set up the cache.
            if ( $attr['cache'] > 0 && is_writable( SB_DIRNAME . '/cache/' ) ) {
                $cache->cache_path = SB_DIRNAME . '/cache/';
                $cache->cache_time = $attr['cache'] * 60;
        		$forceCrawl = false;
        	} else {
        		// cache is not enabled, call local class
                $forceCrawl = true;
        	}
        }

        // order counter
        $GLOBALS['order'] = 0;
        
        if ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            if (@$_SESSION["$label-temp"]) {
            	$_SESSION[$label] = $_SESSION["$label-temp"];
                $_SESSION["$label-temp"] = array();
            }
            if ($_REQUEST['action'] == "sb_liveupdate") {
                $_SESSION["$label-temp"] = @$_SESSION[$label];
                $_SESSION[$label] = array();
            }
        } else {
            $_SESSION[$label] = array();
            unset($_SESSION["$label-temp"]);
        }
        
        // Check which feeds are specified
        $feeds = array();
        foreach ( $this->feed_keys as $key ) {
            for ($i = 1; $i <= 5; $i++) {
        		if ( $keyitems = @$this->sboption['section_'.$key][$key.'_id_'.$i] ) {
                    foreach ($keyitems as $key2 => $eachkey) {
                        if ( ($_REQUEST['action'] == "sb_loadmore" && @$_SESSION[$label]['loadcrawl']) && ! @$_SESSION[$label]['loadcrawl'][$key.$i.$key2])
                            $load_stop = true;
                        else
                            $load_stop = false;
                        if ( ! @$load_stop) {
                        if ( $eachkey != '') {
         			        if ( ! @$attr['tabable'] || $ajax_feed ) {
                                if ( $crawl_limit && $GLOBALS['crawled'] >= $crawl_limit )
                                    break;
                                if ( $feed_data = $this->sb_get_feed( $key, $i, $key2, $eachkey, $results, $setoption, $this->sboption['section_'.$key], $cache, $forceCrawl, $label ) ) {
                                    $feeds[$key][$i][$key2] = $feed_data;
                                    $filterItems[$key] = ($is_feed) ? '<span class="fa-hover sb-'.$key.$filterlabel.'" data-filter=".sb-'.$key.'"><i class="sb-micon sb-'.$key.'"></i></span>' : '<span class="fa-hover sb-'.$key.$filterlabel.'" data-filter=".sb-'.$key.'"><i class="sb-icon sb-'.$key.'"></i></span>';
                                }
                            } else {
                                $activeTab = '';
                                if ( @$attr['position'] == 'normal' || (@$attr['slide'] && ! @$attr['autoclose']) ) {
                                    if ( ! isset($fistTab) ) {
                                        if ( $feed_data = $this->sb_get_feed( $key, $i, $key2, $eachkey, $results, $setoption, $this->sboption['section_'.$key], $cache, $forceCrawl, $label ) ) {
                                            $feeds[$key][$i][$key2] = $feed_data;
                                        }
                                        $fistTab = true;
                                        $activeTab = ' active';
                                    }
                                }
                                
                                $fi = '
                    			<li class="'.$key.@$activeTab.'" data-feed="'.$key.'">';
                                if (@$attr['position'] == 'normal') {
                                    $fi .= '
                                    <span><i class="sb-icon sb-'.$key.'"></i></span>';
                                } else {
                                $fi .= '
                                    <i class="sb-icon sb-'.$key.'"></i>';
                                    if ( $location != 'bottom' )
                                        $fi .= ' <span>'.ucfirst($key).'</span>';
                                }
                    			$fi .= '</li>';
                                $filterItems[$key] = $fi;
                            }
                        }
                        }
                    }
                }
            }
        }

        // set timeline style class
        if ( $is_timeline ) {
            $class[] = ($attr['onecolumn'] == 'true') ? 'timeline onecol' : 'timeline';
            $class[] = 'animated';
        }
        
        if ( ! $ajax_feed) {
            if ( @$style ) {
                $output .= '<style type="text/css">';
                if ( @$themeoption['custom_css'] )
                    $output .= $themeoption['custom_css']."\n";
                foreach ($style as $stKey => $stItem) {
                    $output .= $stKey.'{'.implode(';', $stItem).'}';
                }
                $output .= '</style>';
            }

            if ($is_wall || $is_timeline)
                $output .= '<div id="sb_'.$label.'">';
                
            if ( @$attr['filters'] && ! $is_feed && (@$attr['position'] == 'normal' || ! $is_timeline && ! @$attr['tabable'] ) && @$filterItems ) {
            $output .= '
        		<div class="filter-items">
                    <span class="fa-hover filter-label active" title="'.__( 'Show All', 'social-board' ).'"><i class="sb-icon sb-ellipsis-h"></i></span>
                    '.implode("\n", $filterItems).'
        		</div>';
            }

            $output .= '<div' . @$attr_id . ' class="' . @implode(' ', $class) . '" data-columns>' . "\n";
            if ( $is_feed ) {
                if (@$attr['tabable']) {
                        $minitabs = ( count($filterItems) > 5 ) ? ' minitabs' : '';
                        $output .= '
                        <div class="sb-tabs'.$minitabs.'">
                    		<ul class="sticky" data-nonce="'.wp_create_nonce( 'tabable' ).'">
                            '.implode("\n", $filterItems).'
                    		</ul>
                    	</div>';
                }
                if ( $is_feed ) {
                    if ( ! @$attr['tabable'] && @$attr['slide'] ) {
                        if ( $location == 'left' || $location == 'right' ) {
                            $opener_image = (@$themeoption["section_$typeoption"]['opener_image']) ? $themeoption["section_$typeoption"]['opener_image'] : plugins_url( 'public/img/opener.png', SB_FILE );
                            $output .= '<div class="sb-opener'.@$active.'" title="'.@$attr['label'].'"><img src="'.$opener_image.'" alt="" /></div>';
                        } else {
                            $upicon = '<i class="sb-arrow"></i>';
                        }
                    }
                    if ( @$attr['showheader'] || ($location == 'bottom' && ! @$attr['tabable']) )
                        $output .= '<div class="sb-heading'.@$active.'">'.@$attr['label'].@$upicon.'</div>';
                }
                
                $content_style = (!@$attr['carousel']) ? ' style="height: '.$block_height.'px"' : '';
                $output .= '<div class="sb-content"'.$content_style.'>';
                $output .= '<ul id="ticker_'.$label.'">';
            }
        }

        if ( ! empty($feeds) ) {
            // Loop through the items in the combined feed
            foreach ( $feeds as $feed_class => $feeditem ) {
                foreach ($feeditem as $i => $feeds2) {
                foreach ($feeds2 as $ifeed => $feed) {
                $inner = '';
                if ( $feed_class == 'facebook' ) {
                    if (@$feed) {
                        $facebook_output = ( ! empty($this->sboption['section_facebook']['facebook_output']) ) ? $this->sboption['section_facebook']['facebook_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'comments' => true, 'likes' => true, 'user' => true, 'share' => true, 'info' => true);
                        $iframe = (@$this->sboption['section_facebook']['facebook_iframe']) ? ' class="iframe"' : '';
                        
                    foreach ($feed as $data) {
                    if (@$data) {
                    foreach ($data as $entry) {
                        $url = $play = '';
                        $link = @$entry->link;
                        if ( ! $link) {
                            $idparts = @explode('_', @$entry->id);
                            if ( @count($idparts) > 1 )
                                $link = 'https://www.facebook.com/'.$idparts[0].'/posts/'.$idparts[1];
                            else
                                $link = 'https://www.facebook.com/'.@$entry->from->id.'/posts/'.@$entry->id;
                        }
                        if ( ! $link)
                            $link = @$entry->source;
                        
                        if ( $this->make_remove($link) ) {
                        
                        // body text
                        $content = array();
                        if (@$entry->message)
                            $content[] = $entry->message;
                        if (@$entry->description)
                            $content[] = $entry->description;
                        if (@$entry->story)
                            $content[] = $entry->story;
                        $content = implode("\n", $content);
                        $text = (@$attr['words']) ? $this->word_limiter($content, $link) : @$this->format_text($content);
                        
                        // comments
                        $count = 0;
                        $comments_data = '';
                        $comments_count = ( @$this->sboption['section_facebook']['facebook_comments'] > 0 ) ? $this->sboption['section_facebook']['facebook_comments'] : 0;
                        if ( ! empty($entry->comments->data) && $comments_count ) {
                            foreach ( $entry->comments->data as $comment ) {
                                $count++;
                                $comment_message = (@$attr['commentwords']) ? $this->word_limiter(nl2br($comment->message), @$link, true) : nl2br($comment->message);
                                $comments_data .= '<span class="meta item-comments"><img src="http://graph.facebook.com/' . $comment->from->id . '/picture?type=square" alt="" /><a href="https://www.facebook.com/' . $comment->from->id . '"'.$target.'>' . $comment->from->name . '</a> ' . $comment_message . '</span>';
                                if ( $count >= $comments_count ) break;
                            }
                        }
                        // likes
                        $count = 0;
                        $likes_data = '';
                        $likes_count = ( @$this->sboption['section_facebook']['facebook_likes'] > 0 ) ? $this->sboption['section_facebook']['facebook_likes'] : 0;
                        if ( ! empty($entry->likes->data) && $likes_count ) {
                            foreach ( $entry->likes->data as $like ) {
                                $count++;
                                $likes_data .= '<img src="http://graph.facebook.com/' . $like->id . '/picture?type=square" title="' . $like->name . '" alt="">';
                                if ( $count >= $likes_count ) break;
                            }
                        }
                        
                        $meta = '';
                        if ($comments_data || $likes_data) {
                            $meta .= '
                            <span class="sb-meta">';
                            if (@$facebook_output['comments'] && $comments_data)
                                $meta .= '
                                <span class="meta">
                                    <span class="comments"><i class="sb-bico sb-comments"></i> '.ucfirst(__( 'comments', 'social-board' )).'</span>
                                </span>
                                ' . $comments_data;
                            if (@$facebook_output['likes'] && $likes_data)
                            $meta .= '
                                <span class="meta">
                                    <span class="likes"><i class="sb-bico sb-star"></i> '.ucfirst(__( 'likes', 'social-board' )).'</span>
                                </span>
                                <span class="meta item-likes">
                                    ' . $likes_data . '
                                </span>';
                            $meta .= '
                            </span>';
                        }
                        
                        $image_width = @$this->sboption['section_facebook']['facebook_image_width'];
                        $source = @$entry->picture;
                        if ($iframe) {
                            $url = $source;
                            $image_width_iframe = 800;
                        }
                        if ( ! empty($entry->images) ) {
                            if ($image_width) {
                                // get closest image width
                                $closest = null;
                                foreach ($entry->images as $image) {
                                    if ($closest === null || abs($image_width - $closest) > abs($image->width - $image_width)) {
                                        $closest = $image->width;
                                        $source = $image->source;
                                    }
                                }
                            }
                            // set iframe image
                            if ($iframe) {
                                $closest = null;
                                foreach ($entry->images as $image2) {
                                    if ($closest === null || abs($image_width_iframe - $closest) > abs($image2->width - $image_width_iframe)) {
                                        $closest = $image2->width;
                                        $url = $image2->source;
                                    }
                                }
                            }
                        } else {
                            // get or create thumb
                            if ($image_width > 180) {
                                if (@$entry->full_picture) {
                                    $urlArr = explode('&url=', $entry->full_picture);
                                    if ($urlfb = @$urlArr[1]) {
                                        if (stristr($urlfb, 'fbcdn') == TRUE) {
                                            $source = $entry->full_picture."&w=$image_width&h=$image_width";
                                        } else {
                                            $source = 'https://images1-focus-opensocial.googleusercontent.com/gadgets/proxy?container=focus&resize_w='.$image_width.'&refresh=3600&url='.$urlfb;
                                        }
                                    } else {
                                        $source = $entry->full_picture;
                                    }
                                } else {
                                    if ( $object_id = @$entry->object_id )
                                        $source = 'https://graph.facebook.com/'.$object_id.'/picture?type=normal';
                                }
                            }
                            // set iframe image
                            if ($iframe) {
                                if (@$entry->full_picture) {
                                    $url = $entry->full_picture;
                                } else {
                                    if ( $object_id = @$entry->object_id )
                                        $url = 'https://graph.facebook.com/'.$object_id.'/picture?type=normal';
                                }
                            }
                        }
                        
                        if (@$entry->type == 'video' || $i == 4) {
                            $play = true;
                            if ($iframe)
                                $url = @$entry->source;
                        }
                        
                        switch ($i) {
                            case 3:
                                $type = 'image';
                                $type_icon = @$themeoption['type_icons'][4];
                            break;
                            case 4:
                                $type = 'video-camera';
                                $type_icon = @$themeoption['type_icons'][6];
                            default:
                                $type = 'pencil';
                                $type_icon = @$themeoption['type_icons'][0];
                            break;
                        }
                        
                        $thetime = (@$entry->created_time) ? $entry->created_time : $entry->updated_time;
                        $final[$this->make_timestr($thetime, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'title' => (@$entry->name) ? '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($entry->name) : $entry->name) . '</a>' : '',
                        'thumb' => (@$source) ? $source : '',
                        'thumburl' => $url,
                        'text' => @$text,
                        'meta' => @$meta,
                        'url' => @$link,
                        'iframe' => $iframe,
                        'date' => $thetime,
                        'user' => array(
                            'name' => @$entry->from->name,
                            'url' => 'https://www.facebook.com/' . $entry->from->id,
                            'image' => 'http://graph.facebook.com/' . $entry->from->id . '/picture?type=square',
                            'status' => (@$entry->status_type) ? ucfirst( str_replace('_', ' ', $entry->status_type) ) : ''
                            ),
                        'type' => $type,
                        'play' => @$play,
                        'icon' => array(@$themeoption['social_icons'][0], $type_icon)
                        ), $attr, $facebook_output);
                        }
                    } // end foreach
                    
                    // facebook get last item date
                    $loadcrawl[$feed_class.$i.$ifeed] = strtotime($thetime)-1;
                    
                    } // end $data
                    }
                    }
                }
        		elseif ( $feed_class == 'twitter' ) {
                    if (@$feed) {
                        if ($i == 3)
                            $feed = $feed->statuses;
                            
                        $twitter_output = ( ! empty($this->sboption['section_twitter']['twitter_output']) ) ? $this->sboption['section_twitter']['twitter_output'] : array('thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true);
                        $iframe = (@$this->sboption['section_twitter']['twitter_iframe']) ? ' class="iframe"' : '';
                    
                    foreach ( $feed as $data ) {
                        if ( isset($data->created_at) ) {
                        if ($_SESSION[$label]['loadcrawl'][$feed_class.$i.$ifeed] == $data->id_str)
                            continue;
                        $link = 'https://twitter.com/' . $data->user->screen_name . '/status/' . $data->id_str;
                        if ( $this->make_remove($link) ) {
                        
                        $text = (@$attr['words']) ? $this->word_limiter($data->text) : @$this->format_text($data->text);
                        // Add links to all @ mentions
                        $text = preg_replace('/@([^\s]+)/', '<a href="http://twitter.com/$1"'.$target.'>@$1</a>', $text );
                        // Add links to all hash tags
                        $text = preg_replace('/#([^\s]+)/', '<a href="http://twitter.com/search/%23$1"'.$target.'>#$1</a>', $text );
                        
                        // get image
                        $url = $thumb = '';
                        if (@$data->entities->media[0]) {
                            $twitter_images = $this->sboption['section_twitter']['twitter_images'];
                            $thumb = $data->entities->media[0]->media_url . ':' . $twitter_images;
                            if ($iframe) {
                                $url = $data->entities->media[0]->media_url . ':large';
                            }
                        }
                        
                        $final[$this->make_timestr($data->created_at, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => $thumb,
                        'thumburl' => $url,
                        'iframe' => $iframe,
                        'text' => $text,
                        'share' => (@$twitter_output['share']) ? '
                        <span class="sb-share">
                            <span class="meta">
                                <a href="https://twitter.com/intent/tweet?in_reply_to=' . $data->id_str . '&via=' . $data->user->screen_name . '"'.$target.'><i class="sb-bico sb-reply"></i></a>
                                <a href="https://twitter.com/intent/retweet?tweet_id=' . $data->id_str . '&via=' . $data->user->screen_name . '"'.$target.'><i class="sb-bico sb-retweet"></i> ' . $data->retweet_count . '</a>
                                <a href="https://twitter.com/intent/favorite?tweet_id=' . $data->id_str . '"'.$target.'><i class="sb-bico sb-star-o"></i> ' . $data->favorite_count . '</a>
                            </span>
                        </span>' : null,
                        'url' => $link,
                        'date' => $data->created_at,
                        'user' => array(
                            'name' => '@'.$data->user->screen_name,
                            'url' => 'http://twitter.com/'.$data->user->screen_name,
                            'title' => $data->user->name,
                            'image' => $data->user->profile_image_url
                            ),
                        'type' => 'pencil',
                        'icon' => array(@$themeoption['social_icons'][1], @$themeoption['type_icons'][0])
                        ), $attr, @$twitter_output);
                        }
                        }
                    } // end foreach
                    
                    // twitter get last id
                    $loadcrawl[$feed_class.$i.$ifeed] = @$data->id_str;
                    }
        		}
                elseif ( $feed_class == 'google' ) {
                    $keyTypes = array( 'note' => array('pencil', 0), 'article' => array('edit', 1), 'activity' => array('quote-right', 2), 'photo' => array('image', 5), 'video' => array('video-camera', 6) );
                    $google_output = ( ! empty($this->sboption['section_google']['google_output']) ) ? $this->sboption['section_google']['google_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'stat' => true, 'user' => true, 'share' => true, 'info' => true);
                    $iframe = (@$this->sboption['section_google']['google_iframe']) ? ' class="iframe"' : '';
                    
                    // google next page
                    $loadcrawl[$feed_class.$i.$ifeed] = @$feed->nextPageToken;
                    
                    if (@$feed->items) {
                    foreach ($feed->items as $item) {
                        $url = $play = $text = '';
                        $link = @$item->url;
                        if ( $this->make_remove($link) ) {
                            // get text
                            if ($attachments = @$item->object->attachments[0]) {
                                $image_url = @$attachments->image->url;
                                if ($iframe)
                                    $url = @$attachments->fullImage->url;
                                    
                                if (@$attachments->objectType == 'photo') {
                                    if (@$attachments->displayName) {
                                        $text = (@$attr['words']) ? $this->word_limiter($attachments->displayName, $link) : $this->format_text($attachments->displayName);
                                    }
                                } else {
                                    if (@$attachments->content)
                                        $content = (@$attr['words']) ? $this->word_limiter($attachments->content, $link) : @$this->format_text($attachments->content);
                                    $text = '<span class="sb-title"><a href="' . $attachments->url . '"'.$target.'>'.$attachments->displayName.'</a></span>'.@$content;
                                }
                                
                                if (@$attachments->objectType == 'video') {
                                    $play = true;
                                    if (@$attachments->embed && $iframe) {
                                        $url = $attachments->embed->url;
                                    }
                                }
                            }
                            else
                                $text = (@$attr['words']) ? $this->word_limiter($item->object->content, $link) : @$this->format_text($item->object->content);
                                
                        $final[$this->make_timestr($item->updated, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => (@$image_url) ? $image_url : '',
                        'thumburl' => $url,
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                        'text' => $text,
                        'iframe' => $iframe,
                        'meta' => (@$google_output['stat']) ? '
                        <span class="sb-text">
                            <span class="meta">
                                <span class="plusones">+1s ' . $item->object->plusoners->totalItems . '</span>
                                <span class="shares"><i class="sb-bico sb-users"></i> ' . $item->object->resharers->totalItems . '</span>
                                <span class="comments"><i class="sb-bico sb-comment"></i> ' . $item->object->replies->totalItems . '</span>
                            </span>
                        </span>' : null,
                        'url' => @$link,
                        'date' => @$item->published,
                        'user' => array(
                            'name' => $item->actor->displayName,
                            'url' => $item->actor->url,
                            'image' => @$item->actor->image->url
                            ),
                        'type' => $keyTypes[$item->object->objectType][0],
                        'play' => @$play,
                        'icon' => array(@$themeoption['social_icons'][2], @$themeoption['type_icons'][$keyTypes[$item->object->objectType][1]])
                        ), $attr, @$google_output);
                        }
                    } // end foreach
                    }
                }
                elseif ( $feed_class == 'tumblr' ) {
                    $keyTypes = array( 'text' => array('pencil', 0), 'quote' => array('quote-right', 2), 'link' => array('link', 3), 'answer' => array('reply', 1), 'video' => array('video-camera', 6), 'audio' => array('youtube-play', 7), 'photo' => array('image', 4), 'chat' => array('comment', 9) );
                    $embed = @$this->sboption['section_tumblr']['tumblr_embed'];
                    $iframe = (@$this->sboption['section_tumblr']['tumblr_iframe']) ? ' class="iframe"' : '';
                    
                    // tumblr next page start
                    $total_posts = @$feed->response->total_posts;
                    $loadcrawl[$feed_class.$i.$ifeed] = (@$_SESSION[$label]['loadcrawl'][$feed_class.$i.$ifeed]) ? $_SESSION[$label]['loadcrawl'][$feed_class.$i.$ifeed] + $results : $results;
                    
                    // blog info
                    $blog = $feed->response->blog;
                    
                    if (@$feed->response->posts) {
                        $tumblr_output = (@$this->sboption['section_tumblr']['tumblr_output']) ? $this->sboption['section_tumblr']['tumblr_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true, 'tags' => false);
                        
                    foreach ($feed->response->posts as $item) {
                        $title = $thumb = $text = $object = $tags = $url = '';
                        
                        $link = @$item->post_url;
                        if ( $this->make_remove($link) ) {
                        
                        // tags
                        if ( @$tumblr_output['tags'] ) {
                            if ( @$item->tags ) {
                                $tags = implode(', ', $item->tags);
                            }
                        }
                        
                        if ( @$item->title ) {
                            $title = '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>';
                        }
                        
                        // set image
                        if ($photoItem = @$item->photos[0]) {
                            if (@$photoItem->alt_sizes) {
                                foreach ($photoItem->alt_sizes as $photo) {
                                    if ($photo->width == @$this->sboption['section_tumblr']['tumblr_thumb'])
                                        $thumb = $photo->url;
                                }
                            }
                            // set iframe image
                            if ($iframe) {
                                if ($original = @$photoItem->original_size) {
                                    $url = $original->url;
                                }
                            }
                        }
                        
                        if ( $item->type == 'photo') {
                            $body = @$item->caption;
                        }
                        elseif ( $item->type == 'video') {
                            // set player
                            if ($embed) {
                                if (@$item->player) {
                                    foreach ($item->player as $player) {
                                        if ($player->width == @$this->sboption['section_tumblr']['tumblr_video'])
                                            $object = $player->embed_code;
                                    }
                                }
                            } else {
                                $url = @$item->permalink_url;
                                if (@$item->thumbnail_url)
                                    $thumb = $item->thumbnail_url;
                            }
                            $body = @$item->caption;
                        }
                        elseif ( $item->type == 'audio') {
                            $tit = @$item->artist . ' - ' . @$item->album . ' - ' . @$item->id3_title;
                            $title = '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($tit) : $tit) . '</a>';
                            $thumb = @$item->player;
                            $body = @$item->caption;
                        }
                        elseif ( $item->type == 'link') {
                            $title = '<a href="' . $item->url . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>';
                            $url = $item->url;
                            if (@$item->excerpt)
                                $excerpt = $item->excerpt.'<br />';
                            $body = @$excerpt.@$item->description;
                            if ( ! @$thumb)
                                $thumb = @$item->link_image;
                        }
                        elseif ( $item->type == 'answer') {
                            $body = @$item->question.'<br />'.@$item->answer;
                        }
                        elseif ( $item->type == 'quote') {
                            if (@$item->source)
                                $source = $item->source;
                            $text = '<span class="sb-title">'.@$item->text.'</span>'.@$source;
                        }
                        elseif ( $item->type == 'chat') {
                            $body = @$item->body;
                        }
                        // type = text
                        else {
                            if ( @$item->body )
                                $body = $item->body;
                            
                            // find img
                            if ( ! @$thumb) {
                                $thumb = '';
                                $image = array();
                                preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $body, $image);
                                if ( ! empty($image) )
                                    $thumb = $image[1];
                            }
                        }
                        
                        if ($iframe) {
                            if ( ! @$url )
                                $url = @$thumb;
                        }
                        
                        if ( ! empty($body) ) {
                            if ( ! @$text )
                                $text = (@$attr['words']) ? $this->word_limiter($body, $link) : @$this->format_text($body);
                        }
                        
                        $final[$this->make_timestr($item->timestamp, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'title' => @$title,
                        'thumb' => @$thumb,
                        'thumburl' => $url,
                        'object' => @$object,
                        'iframe' => $iframe,
                        'text' => @$text,
                        'tags' => @$tags,
                        'url' => @$link,
                        'date' => $item->date,
                        'user' => array(
                            'name' => $blog->name,
                            'title' => $blog->title,
                            'url' => $blog->url,
                            'image' => 'http://api.tumblr.com/v2/blog/'.$blog->name.'.tumblr.com/avatar/64'
                            ),
                        'type' => $keyTypes[$item->type][0],
                        'icon' => array(@$themeoption['social_icons'][3], @$themeoption['type_icons'][$keyTypes[$item->type][1]])
                        ), $attr, $tumblr_output);
                        }
                    }
                    }
                }
                elseif ( $feed_class == 'delicious' ) {
                    if (@$feed){
                        $delicious_output = (@$this->sboption['section_delicious']['delicious_output']) ? $this->sboption['section_delicious']['delicious_output'] : array( 'title' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true, 'tags' => false );
                    foreach ($feed as $item) {
                        $link = @$item->u;
                        if ( $this->make_remove($link) ) {
                        // tags
                        $tags = '';
                        if ( @$delicious_output['tags'] ) {
                            $tags = '';
                            if ( @$item->t ) {
                                $tags = implode(', ', $item->t);
                            }
                        }
                        $final[$this->make_timestr($item->dt, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->d) : $item->d) . '</a>',
                        'text' => (@$attr['words']) ? $this->word_limiter(@$item->n, $link) : @$item->n,
                        'tags' => $tags,
                        'url' => $link,
                        'date' => $item->dt,
                        'user' => array('name' => $item->a),
                        'type' => 'pencil',
                        'icon' => array(@$themeoption['social_icons'][4], @$themeoption['type_icons'][0])
                        ), $attr, $delicious_output);
                        }
                    }
                    }
                }
                elseif ( $feed_class == 'pinterest' ) {
                    $pinterest_output = (@$this->sboption['section_pinterest']['pinterest_output']) ? $this->sboption['section_pinterest']['pinterest_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true);
                    $fcount = 0;
                    $channel = @$feed->channel;
                    if (@$channel->item)
                    foreach($channel->item as $item) {
                        $link = @$item->link;
                        if ( $this->make_remove($link) ) {
                        $fcount++;
        
                        if (@$item->category) {
                            foreach($item->category as $category) {
                                $cats[] = (string) $category;
                            }
                        }
                        
                        // fix the links in description
                        $pattern = "/(?<=href=(\"|'))[^\"']+(?=(\"|'))/";
                        if (preg_match($pattern, $item->description, $url1)) {
                            $description = preg_replace($pattern, "https://www.pinterest.com$url1[0]", $item->description);
                        }
                        
                        // find img
                        $thumb = '';
                        $image = array();
                        preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $description, $image);
                        if ( ! empty($image) )
                            $thumb = $image[1];

                        $final[$this->make_timestr($item->pubDate, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                        'text' => (string) (@$attr['words']) ? $this->word_limiter($description, $link) : $description,
                        'thumb' => $thumb,
                        'tags' => @implode(', ', $cats),
                        'url' => $link,
                        'date' => $item->pubDate,
                        'user' => array(
                            'name' => $channel->title,
                            'url' => $channel->link
                            ),
                        'type' => 'pencil',
                        'icon' => array(@$themeoption['social_icons'][5], @$themeoption['type_icons'][0])
                        ), $attr, $pinterest_output);
                        
                        if ( $fcount >= $results ) break;
                        }
                    }
                }
                elseif ( $feed_class == 'flickr' ) {
                    // flickr next page
                    $loadcrawl[$feed_class.$i.$ifeed] = @$feed->photos->page+1;
                    
                    if (@$feed->photos->photo) {
                        $flickr_output = (@$this->sboption['section_flickr']['flickr_output']) ? $this->sboption['section_flickr']['flickr_output'] : array( 'title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true, 'tags' => false );
                        $iframe = (@$this->sboption['section_flickr']['flickr_iframe']) ? ' class="iframe"' : '';
                        
                    foreach ($feed->photos->photo as $media) {
                        $link = 'https://flickr.com/photos/' . $media->owner . '/' . $media->id;
                        if ( $this->make_remove($link) ) {
                        
                        // tags
                        $tags = '';
                        if ( @$flickr_output['tags'] ) {
                            if ( @$media->tags ) {
                                $tags = $media->tags;
                            }
                        }
                        
                        $text = $image = $url = '';
                        if (@$attr['carousel'])
                            $text = (@$attr['words']) ? $this->word_limiter($media->title, $link) : $media->title;
                        
                        $flickr_thumb = (@$this->sboption['section_flickr']['flickr_thumb']) ? $this->sboption['section_flickr']['flickr_thumb'] : 'm';
                        $image = 'https://farm' . $media->farm . '.staticflickr.com/' . $media->server . '/' . $media->id . '_' . $media->secret . '_' . $flickr_thumb . '.jpg';
                        $author_icon = 'https://farm' . $media->iconfarm . '.staticflickr.com/' . $media->iconserver . '/buddyicons/' . $media->owner . '_s.jpg';
                        if ($iframe) {
                            $url = 'https://farm' . $media->farm . '.staticflickr.com/' . $media->server . '/' . $media->id . '_' . $media->secret . '_c.jpg';
                        }
                        
                        $mediadate = (@$media->dateadded) ? $media->dateadded : $media->dateupload;
                        $final[$this->make_timestr($mediadate, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => $image,
                        'thumburl' => $url,
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($media->title) : $media->title) . '</a>',
                        'text' => $text,
                        'tags' => $tags,
                        'iframe' => $iframe,
                        'url' => $link,
                        'date' => $media->datetaken,
                        'user' => array(
                            'name' => @$media->ownername,
                            'url' => 'https://www.flickr.com/people/' . $media->owner . '/',
                            'image' => $author_icon
                            ),
                        'type' => 'image',
                        'icon' => array(@$themeoption['social_icons'][6], @$themeoption['type_icons'][5])
                        ), $attr, $flickr_output);
                        }
                    }
                    }
                }
                elseif ( $feed_class == 'instagram' ) {
                    $keyTypes = array( 'image' => array('camera', 5), 'video' => array('video-camera', 6) );
                    $instagram_output = (@$this->sboption['section_instagram']['instagram_output']) ? $this->sboption['section_instagram']['instagram_output'] : array( 'title' => true, 'thumb' => true, 'text' => true, 'comments' => true, 'likes' => true, 'user' => true, 'share' => true, 'info' => true, 'tags' => false );
                    $iframe = (@$this->sboption['section_instagram']['instagram_iframe']) ? ' class="iframe"' : '';
                    
                    // instagram next page
                    if ($i != 4) {
                        if ($i == 2) {
                            $next_id = @$feed->pagination->next_max_tag_id;
                        } else {
                            $next_id = @$feed->pagination->next_max_id;
                        }
                        $loadcrawl[$feed_class.$i.$ifeed] = $next_id;
                    }
                    
                    if (@$feed->data) {
                    foreach ($feed->data as $item) {
                        $link = $url = @$item->link;
                        if ( $this->make_remove($link) ) {
                        $thumb = '';
                        $instagram_images = (@$this->sboption['section_instagram']['instagram_images']) ? $this->sboption['section_instagram']['instagram_images'] : 'low_resolution';
                        if (@$item->images) {
                            $thumb = $item->images->{$instagram_images}->url;
                            
                            // set iframe image
                            $instagram_images_iframe = 'standard_resolution';
                            if ($iframe) {
                                $url = $item->images->{$instagram_images_iframe}->url;
                            }
                        }
                        
                        if (@$item->type == 'video' && $iframe) {
                            $instagram_videos = (@$this->sboption['section_instagram']['instagram_videos']) ? $this->sboption['section_instagram']['instagram_videos'] : 'low_resolution';
                            $url = $item->videos->{$instagram_videos}->url;
                        }
                        
                        // tags
                        $tags = '';
                        if ( @$instagram_output['tags'] ) {
                            if ( @$item->tags ) {
                                $tags = implode(', ', $item->tags);
                            }
                        }
                        
                        // comments
                        $count = 0;
                        $comments_data = '';
                        $comments_count = ( @$this->sboption['section_instagram']['instagram_comments'] > 0 ) ? $this->sboption['section_instagram']['instagram_comments'] : 0;
                        if ( ! empty($item->comments->data) && $comments_count ) {
                            foreach ( $item->comments->data as $comment ) {
                                $count++;
                                $comment_message = (@$attr['commentwords']) ? $this->word_limiter($comment->text, $link, true) : $comment->text;
                                $comments_data .= '<span class="meta item-comments"><img src="' . $comment->from->profile_picture . '" alt=""><a href="http://instagram.com/' . $comment->from->username . '"'.$target.'>' . $comment->from->full_name . '</a> ' . $comment_message . '</span>';
                                if ( $count >= $comments_count ) break;
                            }
                        }
                        // likes
                        $count = 0;
                        $likes_data = '';
                        $likes_count = ( @$this->sboption['section_instagram']['instagram_likes'] > 0 ) ? $this->sboption['section_instagram']['instagram_likes'] : 0;
                        if ( ! empty($item->likes->data) && $likes_count ) {
                            foreach ( $item->likes->data as $like ) {
                                $count++;
                                $likes_data .= '<img src="' . $like->profile_picture . '" title="' . $like->full_name . '" alt="">';
                                if ( $count >= $likes_count ) break;
                            }
                        }
                        
                        $meta = '';
                        if ($comments_data || $likes_data || @$instagram_output['comments'] || @$instagram_output['likes']) {
                            $meta .= '
                            <span class="sb-meta">';
                            if (@$instagram_output['comments']) {
                                $meta .= '
                                    <span class="meta">
                                        <span class="comments"><i class="sb-bico sb-comments"></i> ' . $item->comments->count . ' '.__( 'comments', 'social-board' ).'</span>
                                    </span>';
                                if ($comments_data)
                                    $meta .= $comments_data;
                            }
                            if (@$instagram_output['likes']) {
                            $meta .= '
                                <span class="meta">
                                    <span class="likes"><i class="sb-bico sb-star"></i> ' . $item->likes->count . ' '.__( 'likes', 'social-board' ).'</span>
                                </span>';
                            if ($likes_data)
                                $meta .= '
                                <span class="meta item-likes">
                                    ' . $likes_data . '
                                </span>';
                            }
                            $meta .= '
                            </span>';
                        }
                        
                        $text = (@$attr['words']) ? $this->word_limiter(@$item->caption->text, $link) : @$this->format_text($item->caption->text);
                        // Add links to all hash tags
                        if ( @$item->tags ) {
                            foreach ($item->tags as $hashtag) {
                                $text = str_ireplace('#'.$hashtag, '<a href="https://instagram.com/explore/tags/'.$hashtag.'/"'.$target.'>#'.$hashtag.'</a>', $text);
                            }
                        }
                        
                        $final[$this->make_timestr($item->created_time, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => @$thumb,
                        'thumburl' => $url,
                        'iframe' => $iframe,
                        'text' => $text,
                        'meta' => @$meta,
                        'tags' => $tags,
                        'url' => $link,
                        'date' => $item->created_time,
                        'user' => array(
                            'name' => $item->user->username,
                            'title' => @$item->user->full_name,
                            'url' => 'https://instagram.com/'.$item->user->username.'/',
                            'image' => @$item->user->profile_picture
                            ),
                        'type' => @$keyTypes[$item->type][0],
                        'play' => (@$item->type == 'video') ? true : false,
                        'icon' => array(@$themeoption['social_icons'][7], @$themeoption['type_icons'][$keyTypes[$item->type][1]])
                        ), $attr, $instagram_output);
                        }
                    } // end foreach
                    
                    // next page timestamp only for /media/search
                    if ( $i == 4 && ! @$next_id)
                        $loadcrawl[$feed_class.$i.$ifeed] = @$item->created_time;
                    }
                }
                elseif ( $feed_class == 'youtube' ) {
                    $iframe = ($this->sboption['section_youtube']['youtube_iframe']) ? ' class="iframe"' : '';
                    $youtube_output = (@$this->sboption['section_youtube']['youtube_output']) ? $this->sboption['section_youtube']['youtube_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true);
                    
                    // youtube next page
                    $loadcrawl[$feed_class.$i.$ifeed] = @$feed->nextPageToken;
                    
                    if (@$feed->items)
                    foreach ($feed->items as $item) {
                        $watchID = ($i == 3) ? @$item->id->videoId : @$item->snippet->resourceId->videoId;
                        $link = 'http://www.youtube.com/watch?v='.$watchID;
                        $snippet = $item->snippet;
                        if ( $this->make_remove($link) ) {
                        $dateof = @$snippet->publishedAt;
                        $title = @$snippet->title;
                        $text = @$snippet->description;
                        $text = (@$attr['words']) ? $this->word_limiter(@$text, $link) : @$this->format_text($text);

                        $thumb = '';
                        $url = $link;
                        if ($iframe) {
                            $url = 'http://www.youtube.com/embed/' . $watchID . '?rel=0&wmode=transparent';
                        }
                        $thumbnail = @$snippet->thumbnails->{$this->sboption['section_youtube']['youtube_thumb']};
                        if ( ! $thumbnail )
                            $thumbnail = @$snippet->thumbnails->{'medium'};
                        $thumb = @$thumbnail->url;
                        
                        $final[$this->make_timestr($dateof, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => $thumb,
                        'thumburl' => $url,
                        'iframe' => $iframe,
                        'title' => '<a href="' . $link . '"'.$iframe.$target.'>' . (@$attr['titles'] ? $this->title_limiter($title) : $title) . '</a>',
                        'text' => $text,
                        'url' => $link,
                        'date' => $dateof,
                        'user' => array(
                            'name' => $snippet->channelTitle,
                            'url' => 'https://www.youtube.com/channel/'.$snippet->channelId
                            ),
                        'type' => 'youtube-play',
                        'play' => true,
                        'icon' => array(@$themeoption['social_icons'][8], @$themeoption['type_icons'][6])
                        ), $attr, $youtube_output);
                        }
                    }
                }
                elseif ( $feed_class == 'vimeo' ) {
                    $iframe = ($this->sboption['section_vimeo']['vimeo_iframe']) ? ' class="iframe"' : '';
                    $vimeo_output = ( ! empty($this->sboption['section_vimeo']['vimeo_output']) ) ? $this->sboption['section_vimeo']['vimeo_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true);
                    if (@$feed) {
                    foreach ($feed as $dataKey => $data) {
                        foreach ($data as $item) {
                            $link = @$item->url;
                            if ( $this->make_remove($link) ) {
                                $thumb = '';
                            if ($dataKey == 'channels' || $dataKey == 'groups') {
                                $datetime = @$item->created_on;
                                $user_image = $thumb = $item->logo;
                                $title = $item->name;
                                if ($dataKey == 'groups') {
                                $meta = '
                                <span class="sb-text">
                                    <span class="meta">
                                        <span class="views"><i class="sb-bico sb-play-circle"></i> ' . $item->total_videos . '</span>
                                    </span>
                                </span>';
                                } else {
                                $meta = '
                                <span class="sb-text">
                                    <span class="meta">
                                        <span class="views"><i class="sb-bico sb-play-circle"></i> ' . $item->total_videos . '</span>
                                        <span class="subscribers"><i class="sb-bico sb-check-square-o"></i> ' . $item->total_subscribers . '</span>
                                    </span>
                                </span>';
                                }
                                $user_name = $item->creator_display_name;
                                $user_url = $item->creator_url;
                            } else {
                                $vimeo_thumb = (@$this->sboption['section_vimeo']['vimeo_thumb']) ? $this->sboption['section_vimeo']['vimeo_thumb'] : 'medium';
                                $thumb = $item->{"thumbnail_$vimeo_thumb"};
                                $title = $item->title;
                                $url = ($iframe) ? 'http://player.vimeo.com/video/'. $item->id : $link;
                                
                                if ($dataKey == 'albums') {
                                    $datetime = @$item->last_modified;
                                $meta = '
                                <span class="sb-text">
                                    <span class="meta">
                                        <span class="views"><i class="sb-bico sb-play-circle"></i> ' . @$item->total_videos . '</span>
                                    </span>
                                </span>';
                                } else {
                                $datetime = @$item->upload_date;
                                $meta = '
                                <span class="sb-text">
                                    <span class="meta">
                                        <span class="likes"><i class="sb-bico sb-thumbs-up"></i> ' . @$item->stats_number_of_likes . '</span>
                                        <span class="views"><i class="sb-bico sb-play-circle"></i> ' . @$item->stats_number_of_plays . '</span>
                                        <span class="comments"><i class="sb-bico sb-comment"></i> ' . @$item->stats_number_of_comments . '</span>
                                        <span class="duration"><i class="sb-bico sb-clock-o"></i> ' . @$item->duration . ' secs</span>
                                    </span>
                                </span>';
                                $user_name = @$item->user_name;
                                $user_url = @$item->user_url;
                                $user_image = @$item->user_portrait_medium;
                                }
                            }
                            
                            $final[$this->make_timestr($datetime, $link)] = $layoutobj->sb_create_item($feed_class,
                            array(
                            'thumb' => @$thumb,
                            'thumburl' => @$url,
                            'iframe' => $iframe,
                            'title' => '<a href="' . $link . '"'.@$iframe.$target.'>' . (@$attr['titles'] ? $this->title_limiter($title) : $title) . '</a>',
                            'text' => (@$attr['words']) ? $this->word_limiter($item->description, $link) : $item->description,
                            'meta' => (@$vimeo_output['share']) ? $meta : null,
                            'url' => $link,
                            'date' => $datetime,
                            'user' => array(
                                'name' => $user_name,
                                'url' => $user_url,
                                'image' => $user_image
                                ),
                            'type' => 'video-camera',
                            'play' => true,
                            'icon' => array(@$themeoption['social_icons'][9], @$themeoption['type_icons'][6])
                            ), $attr, @$vimeo_output);
                            }
                        }
                    }
                    }
                }
                elseif ( $feed_class == 'stumbleupon' ) {
                    $stumbleupon_output = ( ! empty($this->sboption['section_stumbleupon']['stumbleupon_output']) ) ? $this->sboption['section_stumbleupon']['stumbleupon_output'] :  array( 'title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'share' => true, 'info' => true );
                    $fcount = 0;
                    if (@$feed)
                    foreach ($feed as $dataKey => $data) {
                        if (@$this->sboption['section_stumbleupon']['stumbleupon_feeds'][$dataKey]) {
                        $channel = $data->channel;
                        $items = ( $dataKey == 'likes' ) ? $channel->item : $data->item;
                        foreach($items as $item) {
                            $link = @$item->link;
                            if ( $this->make_remove($link) ) {
                            $fcount++;
                            
                            // find user
                            $pattern = ( $dataKey == 'likes' ) ? '/http:\/\/www.stumbleupon.com\/stumbler\/(\w+)/i' : '/http:\/\/www.stumbleupon.com\/stumbler\/(\w+)\/comments/i';
                            $replacement = '$1';
                            $user_name = preg_replace($pattern, $replacement, $channel->link);
                            
                            $thumb = '';
                            $text = '';
                            $image = array();
                            if ($description = (string) @$item->description) {
                                if (@$attr['words']) {
                                    preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $description, $image);
                                    if ( ! empty($image) )
                                        $thumb = $image[1];
                                    $text = $this->word_limiter($description, $link);
                                }
                                else {
                                    $text = $description;
                                }
                            }

                            $final[$this->make_timestr($item->pubDate, $link)] = $layoutobj->sb_create_item($feed_class,
                            array(
                            'thumb' => $thumb,
                            'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                            'text' => $text,
                            'url' => $link,
                            'date' => $item->pubDate,
                            'user' => array(
                                'name' => $user_name,
                                'url' => "http://www.stumbleupon.com/stumbler/$user_name",
                                'title' => @$channel->title
                                ),
                            'type' => ( $dataKey == 'likes' ) ? 'star-o' : 'comment-o',
                            'icon' => array(@$themeoption['social_icons'][10], @$themeoption['type_icons'][( $dataKey == 'likes' ) ? 8 : 9])
                            ), $attr, $stumbleupon_output);
                            
                            if ( $fcount >= $results ) break;
                            }
                        }
                        }
                    }
                }
                elseif ( $feed_class == 'deviantart' ) {
                    $fcount = 0;
                    $channel = @$feed->channel;
                    if (@$channel->item)
                    foreach($channel->item as $item) {
                        $link = @$item->link;
                        if ( $this->make_remove($link) ) {
                        $fcount++;

                        $description = $item->children('media', true)->description;
                        
                        $final[$this->make_timestr($item->pubDate, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => @$item->children('media', true)->thumbnail->{1}->attributes()->url,
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                        'text' => (@$attr['words']) ? $this->word_limiter($description, $link) : $description,
                        'tags' => '<a href="' . $item->children('media', true)->category . '"'.$target.'>' . $item->children('media', true)->category->attributes()->label . '</a>',
                        'url' => $link,
                        'date' => $item->pubDate,
                        'user' => array(
                            'name' => $item->children('media', true)->credit->{0},
                            'url' => $item->children('media', true)->copyright->attributes()->url,
                            'image' => $item->children('media', true)->credit->{1}),
                        'type' => 'image',
                        'icon' => array(@$themeoption['social_icons'][11], @$themeoption['type_icons'][4])
                        ), $attr, $this->sboption['section_deviantart']['deviantart_output'] );
                        
                        if ( $fcount >= $results ) break;
                        }
                    }
                }
                elseif ( $feed_class == 'rss' ) {
                    $rss_output = (@$this->sboption['section_rss']['rss_output']) ? $this->sboption['section_rss']['rss_output'] : array('title' => true, 'thumb' => true, 'text' => true, 'user' => true, 'tags' => false, 'share' => true, 'info' => true);
                    $fcount = 0;
                    if ( $channel = @$feed->channel ) { // rss
                        if (@$channel->item)
                        foreach($channel->item as $item) {
                            $link = @$item->link;
                            if ( $this->make_remove($link) ) {
                            $fcount++;

                            $thumb = '';
                            foreach($item->children('media', true)->thumbnail as $thumbnail) {
                                $thumb = $thumbnail->attributes()->url;
                            }
                            
                            if (@$item->category && @$rss_output['tags'])
                            foreach($item->category as $category) {
                                $cats[] = (string) $category;
                            }
                            
                            // set Snippet or Full Text
                            if (@$this->sboption['section_rss']['rss_text'])
                                $description = (@$item->children("content", true)->encoded) ? $item->children("content", true)->encoded : $item->description;
                            else
                                $description = $item->description;
                                
                            $text = '';
                            $image = array();
                            if (@$description) {
                                $description = preg_replace("/<script.*?\/script>/s", "", $description);
                                if (@$attr['words']) {
                                    $text = $this->word_limiter($description, $link);
                                }
                                else {
                                    $text = $description;
                                }
                            }

                            $final[$this->make_timestr($item->pubDate, $link)] = $layoutobj->sb_create_item($feed_class,
                            array(
                            'thumb' => (@$thumb) ? $thumb : '',
                            'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                            'text' => $text,
                            'tags' => @implode(', ', $cats),
                            'url' => $link,
                            'date' => $item->pubDate,
                            'user' => array(
                                'name' => $channel->title,
                                'url' => $channel->link,
                                'image' => @$channel->image->url
                                ),
                            'type' => 'pencil',
                            'icon' => array(@$themeoption['social_icons'][12], @$themeoption['type_icons'][0])
                            ), $attr, $rss_output);
                            
                            if ( $fcount >= $results ) break;
                            }
                        }
                    } elseif ( $entry = @$feed->entry ) { // atom
                        // get feed link
                        foreach($feed->link as $link) {
                            if ($link->attributes()->rel == 'alternate')
                                $user_url = $link->attributes()->href;
                        }
                        foreach($feed->entry as $item) {
                            $link = @$item->link[0]->attributes()->href;
                            if ( $this->make_remove($link) ) {
                            $fcount++;
    
                            $title = (string) $item->title;
                            $thumb = '';
                            foreach($item->media as $thumbnail) {
                                $thumb = $thumbnail->attributes()->url;
                            }
                            
                            $cats = '';
                            if (@$item->category && @$rss_output['tags']) {
                                foreach($item->category as $category) {
                                    $cats .= $category->attributes()->term.', ';
                                }
                                $cats = rtrim($cats, ", ");
                            }

                            // set Snippet or Full Text
                            if (@$this->sboption['section_rss']['rss_text']) {
                                $content = (string) @$item->content;
                                $description = ($content) ? $content : (string) $item->summary;
                            } else
                                $description = (string) $item->summary;
                                
                            $text = '';
                            $image = array();
                            if (@$description) {
                                if (@$attr['words']) {
                                    if (!$thumb) {
                                        preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $description, $image);
                                        if ( ! empty($image) )
                                            $thumb = $image[1];
                                    }
                                    $text = $this->word_limiter($description, $link);
                                }
                                else {
                                    $text = $description;
                                }
                            }
                            
                            $final[$this->make_timestr($item->published, $link)] = $layoutobj->sb_create_item($feed_class,
                            array(
                            'thumb' => @$thumb,
                            'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($title) : $title) . '</a>',
                            'text' => @$text,
                            'tags' => @$cats,
                            'url' => $link,
                            'date' => $item->published,
                            'user' => array(
                                'name' => $feed->title,
                                'url' => @$user_url,
                                'image' => @$feed->logo
                                ),
                            'type' => 'pencil',
                            'icon' => array(@$themeoption['social_icons'][12], @$themeoption['type_icons'][0])
                            ), $attr, $rss_output);
                            
                            if ( $fcount >= $results ) break;
                            }
                        }
                    }
                }
                elseif ( $feed_class == 'soundcloud' ) {
                    $soundcloud_output = (@$this->sboption['section_soundcloud']['soundcloud_output']) ? $this->sboption['section_soundcloud']['soundcloud_output'] : array('title' => true, 'text' => true, 'thumb' => true, 'user' => true, 'share' => true, 'info' => true, 'meta' => true, 'tags' => false);
                    if (@$feed)
                    foreach ($feed as $item) {
                        $link = @$item->permalink_url;
                        if ( $this->make_remove($link) ) {
                        // tags
                        $tags = '';
                        if ( @$soundcloud_output['tags'] ) {
                            if (@$item->tag_list)
                                $tags .= $item->tag_list;
                        }
                        
                        // convert duration to mins
                        $duration = '';
                        if (@$item->duration) {
                            $seconds = floor($item->duration / 1000);
                            $duration = floor($seconds / 60);
                        }
                        
                        $download = '';
                        if (@$item->download_url) {
                            $soundcloud_client_id = @$setoption['section_soundcloud']['soundcloud_client_id'];
                            $download .= '<span class="download"><i class="sb-bico sb-cloud-download"></i> ' . @$item->download_count . '</span>';
                            //<a title="Download" href="' . @$item->download_url . '?client_id='.$soundcloud_client_id.'"'.$target.'></a>
                        }
                        
                        $meta = '
                        <span class="sb-text">
                            <span class="meta">
                                <span class="likes"><i class="sb-bico sb-thumbs-up"></i> ' . @$item->favoritings_count . '</span>
                                <span class="views"><i class="sb-bico sb-play-circle"></i> ' . @$item->playback_count . '</span>
                                <span class="comments"><i class="sb-bico sb-comment"></i> ' . @$item->comment_count . '</span>
                                <span class="duration"><i class="sb-bico sb-clock-o"></i> ' . @$duration . ' mins</span>
                                ' . $download . '
                            </span>
                        </span>';
                        
                        $final[$this->make_timestr($item->created_at, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'title' => '<a href="' . $link . '"'.$target.'>' . (@$attr['titles'] ? $this->title_limiter($item->title) : $item->title) . '</a>',
                        'text' => (@$attr['words']) ? $this->word_limiter(@$item->description, $link) : @$item->description,
                        'thumb' => (@$item->artwork_url) ? $item->artwork_url : '',
                        'tags' => $tags,
                        'url' => $link,
                        'meta' => (@$soundcloud_output['meta']) ? $meta : null,
                        'date' => $item->created_at,
                        'user' => array(
                            'name' => $item->user->username,
                            'url' => $item->user->permalink_url,
                            'image' => $item->user->avatar_url
                            ),
                        'type' => 'youtube-play',
                        'icon' => array(@$themeoption['social_icons'][13], @$themeoption['type_icons'][7])
                        ), $attr, $soundcloud_output);
                        }
                    }
                }
                elseif ( $feed_class == 'vk' ) {
                    if (@$feed) {
                        $vk_output = (@$this->sboption['section_vk']['vk_output']) ? $this->sboption['section_vk']['vk_output'] : array( 'thumb' => true, 'text' => true, 'stat' => true, 'user' => true, 'share' => true, 'info' => true );
                        $iframe = (@$this->sboption['section_vk']['vk_iframe']) ? ' class="iframe"' : '';
                        
                    // vk next page start
                    $offset = @$feed->offset;
                    $loadcrawl[$feed_class.$i.$ifeed] = ($offset == 0) ? $results : $results + $offset;
                    
                    if ($groups = @$feed->response->groups) {
                        foreach ($feed->response->groups as $group) {
                            $groupdata['-'.$group->id] = $group;
                        }
                    }
                    if ($profiles = @$feed->response->profiles) {
                        foreach ($feed->response->profiles as $profile) {
                            $userdata[$profile->id] = $profile;
                        }
                    }
                    if (@$feed->response)
                    foreach ($feed->response->items as $entry) {
                        $link = 'http://vk.com/wall'.@$entry->owner_id.'_'.@$entry->id;
                        if ( $this->make_remove($link) ) {
                        
                        // body text
                        $text = @$entry->text;
                        if ( ! $text) {
                            if (@$entry->copy_history)
                                $text = $entry->copy_history[0]->text;
                        }
                        $text = (@$attr['words']) ? @$this->word_limiter($text, $link) : @$this->format_text($text);
                        // Add links to all hash tags
                        $text = preg_replace('/#([^\s]+)/', '<a href="http://vk.com/feed?section=search&q=%23$1"'.$target.'>#$1</a>', $text );
                        
                        // user info
                        $user = (@$userdata[$entry->from_id]) ? $userdata[$entry->from_id] : $groupdata[$entry->from_id];
                        $user_name = (@$user->name) ? $user->name : $user->first_name.' '.$user->last_name;
                        $user_image = $user->photo_50;
                        $user_url = ($user->screen_name) ? 'http://vk.com/' . $user->screen_name : 'http://vk.com/id' . $entry->from_id;
                        
                        // get image
                        $image_width = @$this->sboption['section_vk']['vk_image_width'];
                        $attachments = @$entry->attachments;
                        if ( ! $attachments) {
                            if (@$entry->copy_history)
                                $attachments = $entry->copy_history[0]->attachments;
                        }
                        $source = $iframe2 = $play = $url = '';
                        if ( ! empty($attachments) ) {
                            if ($image_width) {
                                foreach ($attachments as $attach) {
                                    if ($attach->type == 'photo') {
                                        $photo_width = "photo_$image_width";
                                        if ( ! @$attach->photo->{$photo_width} ) {
                                            $source = $this->vk_get_photo(@$attach->photo);
                                        } else {
                                            $source = @$attach->photo->{$photo_width};
                                        }
                                        if ($iframe) {
                                            $iframe2 = $iframe;
                                            $photo_width_iframe = "photo_1280";
                                            if ( ! @$attach->photo->{$photo_width_iframe} ) {
                                                $url = $this->vk_get_photo(@$attach->photo);
                                            } else {
                                                $url = @$attach->photo->{$photo_width_iframe};
                                            }
                                        }
                                        break;
                                    } elseif ($attach->type == 'link') {
                                        $source = (@$attach->link->image_big) ? $attach->link->image_big : @$attach->link->image_src;
                                        $url = @$attach->link->url;
                                        break;
                                    } elseif ($attach->type == 'video') {
                                        $play = true;
                                        $source = ($image_width <= 130) ? @$attach->video->photo_130 : @$attach->video->photo_320;
                                        break;
                                    } elseif ($attach->type == 'doc') {
                                        $source = $this->vk_get_photo(@$attach->doc);
                                        break;
                                    }
                                }
                            }
                        }
                        
                        $meta = (@$vk_output['stat']) ? '
                        <span class="sb-text">
                            <span class="meta">
                                <span class="likes"><i class="sb-bico sb-thumbs-up"></i>' . $entry->likes->count . '</span>
                                <span class="shares"><i class="sb-bico sb-retweet"></i> ' . $entry->reposts->count . '</span>
                                <span class="comments"><i class="sb-bico sb-comment"></i> ' . $entry->comments->count . '</span>
                            </span>
                        </span>' : null;
                        
                        $final[$this->make_timestr($entry->date, $link)] = $layoutobj->sb_create_item($feed_class,
                        array(
                        'thumb' => (@$source) ? $source : '',
                        'thumburl' => $url,
                        'text' => @$text,
                        'meta' => @$meta,
                        'url' => @$link,
                        'iframe' => @$iframe2,
                        'date' => $entry->date,
                        'user' => array(
                            'name' => @$user_name,
                            'url' => $user_url,
                            'image' => @$user_image
                            ),
                        'type' => 'pencil',
                        'play' => @$play,
                        'icon' => array(@$themeoption['social_icons'][14], ($i == 2) ? @$themeoption['type_icons'][4] : @$themeoption['type_icons'][0] )
                        ), $attr, $vk_output);
                        }
                    } // end foreach
                    } // end $feed
                }

                // each network sorting
                if ( ! empty($final) ) {
                    krsort($final);
                    reset($final);
                    $ifeedclass = $feed_class.$i.$ifeed;
                    
                    if ( ! empty($loadmore) ) {
                        // filter last items
                        if ( $lastloaditem = $loadmore[$ifeedclass] ) {
                            $loadremovefrom = array_search( $lastloaditem, array_keys($final) );
                            if ( ! @$loadremovefrom) $loadremovefrom = 0;
                            if ( empty($_SESSION[$label]['loadcrawl'][$ifeedclass]) )
                                $loadremovefrom++;
                            $final = array_slice($final, $loadremovefrom);
                        }
                    }

                    $ranking[key($final)] = $ifeedclass;
                    $finals[$ifeedclass] = $final;
                    $rankcount[$ifeedclass] = count($final);
                }
                $final = array();
                
                } // end foreach
                }
            } // end foreach $feeds

            if ( @$ranking ) {
                // defining limits by recent basis
                krsort($ranking);
                $rsum = 0;
                $rnum = count($ranking);
                for ($i = 1; $i <= $rnum; $i++) {
                    $rsum += $i;
                }
                $i = $rnum;
                foreach ($ranking as $cfeed) {
                    $rank[$cfeed] = round( ($i * 100) / $rsum );
                    $i--;
                }
            }

            if ( @$rankcount ) {
                $maxcountkey = array_search(max($rankcount), $rankcount);
                foreach ($rankcount as $rkey => $rval) {
                    $fresults[$rkey] = @round($rank[$rkey] * $results / 100);
                }
                foreach ($rankcount as $rkey => $rval) {
                    if ( $fresults[$rkey] > $rval ) {
                        $diffrankcount = $fresults[$rkey] - $rval;
                        $fresults[$rkey] -= $diffrankcount;
                        $fresults[$maxcountkey] += $diffrankcount;
                    }
                }
            }
            
            if ( @$finals ) {
                // filnal sorting and adding
                foreach ($finals as $fkey => $fval) {
                    $fcount = 0;
                    // limit last result
                    foreach ($fval as $key => $val) {
                        $fcount++;
                        $final[$key] = $val;
                        $loadmore[$fkey] = $key;
                        if ( $fcount >= $fresults[$fkey] ) break;
                    }
                }

                if ( array_sum($rankcount) <= $results && ! $is_feed && ( ! $GLOBALS['islive'] || $_REQUEST['action'] == "sb_loadmore" ) ) {
                    // set next pages if exist
                    foreach ($rankcount as $rkey => $rval) {
                        if (@$loadcrawl[$rkey])
                            $_SESSION[$label]['loadcrawl'][$rkey] = $loadcrawl[$rkey];
                    }
                }
                
                krsort($final);
                if ( $order == 'random' ) shuffle($final);
                foreach ($final as $key => $val) {
                    $output .= $val;
                }
            } else {
                $output_error = '<p class="sboard-nodata"><strong>Social Board:</strong> There is no feed data to display!</p>';
            }
        } else {
            if ( empty($loadmore) )
                $output_error = '<p class="sboard-nodata"><strong>Social Board: </strong>There is no feed to show or there is a connectivity problem to the world wide web!</p>';
        }

        if (@$attr['loadmore']) {
            $_SESSION[$label]['loadmore'] = $loadmore;
        }
        
        if ($ajax_feed && $is_feed) {
            if (@$output_error)
                $output .= $output_error;
        }
        
    	if ( ! $ajax_feed) {
            if ( $is_feed ) {
                if (@$output_error)
                    $output .= $output_error;
                $output .= "</ul></div>";
                
                if (!@$attr['carousel']){
                if (@$attr['autostart']) {
                    $play_none = ' style="display: none;"';
                } else {
                    $pause_none = ' style="display: none;"';
                }
                $controls = (@$attr['controls']) ? '
                    <div class="control">
                        <span class="fa-hover" id="ticker-next-'.$label.'"><i class="sb-bico sb-wico sb-arrow-down"></i></span>
                        <span class="fa-hover" id="ticker-prev-'.$label.'"><i class="sb-bico sb-wico sb-arrow-up"></i></span>
                        <span class="fa-hover" id="ticker-pause-'.$label.'"'.@$pause_none.'><i class="sb-bico sb-wico sb-pause"></i></span>
                        <span class="fa-hover" id="ticker-play-'.$label.'"'.@$play_none.'><i class="sb-bico sb-wico sb-play"></i></span>
                    </div>' : '';
                    
                $filters = '';
                if ( ! @$attr['tabable'] && @$filterItems && ! empty($feeds) ) {
                    $filters = (@$attr['filters']) ? '
                    <div class="filter">
                        <span class="fa-hover active" data-filter="all"><i class="sb-bico sb-wico sb-ellipsis-h" title="'.__( 'Show All', 'social-board' ).'"></i></span>
                        '.implode("\n", $filterItems).'
                    </div>' : '';
                }
                
                if (@$attr['filters'] or @$attr['controls'])
                $output .= '
                <div class="toolbar">
                    '.$controls.'
                    '.$filters.'
                </div>'."\n";
            }
            }
        }

        if ($is_wall || $is_timeline) {
            if (@$output_error) {
                $output = str_replace(' timeline ', ' ', $output);
                $output .= $output_error;
            }
        }
        
        if ( ! $ajax_feed) {
        $output .= "</div>\n";
        if ( ! $is_feed && ! @$output_error )
            $output .= '<div class="sb-loadmore" data-nonce="'.wp_create_nonce( 'loadmore' ).'"><p>'.__( 'Load More', 'social-board' ).'</p></div>'."\n";
        if ($is_wall || $is_timeline)
            $output .= "</div>\n";

        $iframe_output = (@$iframe || @$attr['tabable']) ? '$("#timeline_'.$label.' .iframe").colorbox({iframe:true, innerWidth:640, innerHeight:390});' : '';
        
        // loadmore ajax function
        if (@$attr['loadmore']) {
        	$more_output = '
                jQuery("#sb_'.$label.'").on("click", ".sb-loadmore", function() {
                  nonce = $(this).attr("data-nonce");';
                $more_output .= "$('#sb_".$label." .sb-loadmore').html('<p class=\"sb-loading\">&nbsp;</p>');";
                $more_output .= '
                  $.ajax({
                    type: "post",
                    url: "'.admin_url( 'admin-ajax.php' ).'",
                    data: {action: "sb_loadmore", attr: '.$attr_ajax.', nonce: nonce, label: "'.$label.'"},
                    cache: false
                    })
                    .done(function( response ) {
                        $("#timeline_'.$label.'").append(response);';
                if ( $is_wall )
                    $more_output .= '
            			wall.container.find(".sb-item img").load(function() {
            				wall.fitWidth();
            			});
                        wall.fitWidth();';
                    $more_output .= '
                        '.$iframe_output.'
                        $("#sb_'.$label.' .sb-loadmore").html("<p>'.__( 'Load More', 'social-board' ).'</p>");
                    })
                    .fail(function() {
                        alert( "Problem reading the feed data!" );
                    });
                });';
        }
        
        $ticker_id_t = '';
        if ( $is_feed ) {
            if (@$attr['carousel']) {
                $cs_auto = (@$attr['cs_auto']) ? 'slider.play();' : '';
                if ( ! @is_array($attr['cs_item']) )
                    $attr['cs_item'] = $defoption['carouselsetting']['cs_item'];
        $output .= '
        <script>
        	 jQuery(document).ready(function($) {
    			var slider = $("#ticker_'.$label.'").lightSlider({
                    item: '.@$attr['cs_item'][0].',
                    autoWidth: '.@$attr['autoWidth'].',
                    slideMove: '.@$attr['slideMove'].',
                    slideMargin: '.@$attr['slideMargin'].',
                    auto: '.(@$attr['cs_auto'] ? 'true' : 'false').',
                    loop: '.(@$attr['cs_loop'] ? 'true' : 'false').',
                    controls: '.(@$attr['cs_controls'] ? 'true' : 'false').',
                    rtl: '.@$attr['cs_rtl'].',
                    pager: '.(@$attr['cs_pager'] ? 'true' : 'false').',
                    speed: '.@$attr['cs_speed'].',
                    responsive : [
                        {
                            breakpoint:960,
                            settings: {
                                item: '.@$attr['cs_item'][1].'
                              }
                        },
                        {
                            breakpoint:768,
                            settings: {
                                item: '.@$attr['cs_item'][2].'
                              }
                        },
                        {
                            breakpoint:600,
                            settings: {
                                item: '.@$attr['cs_item'][3].'
                              }
                        },
                        {
                            breakpoint:480,
                            settings: {
                                item: '.@$attr['cs_item'][4].'
                              }
                        }
                    ]
                });
                ' . $cs_auto . '
    		});
        </script>';
            }
        $output .= '
        <script type="text/javascript">
            jQuery(document).ready(function($) {';
                if (!@$attr['carousel']) {
                $ticker_id = '#ticker_'.$label;
                $output .= '
                $("'.$ticker_id.'").newsTicker({
                    row_height: '.$block_height.',
                    max_rows: 1,
                    speed: '.@$attr['rotate_speed'].',
                    duration: '.@$attr['duration'].',
                    direction: "'.@$attr['direction'].'",
                    autostart: '.@$attr['autostart'].',
                    pauseOnHover: '.@$attr['pauseonhover'].',
                    prevButton: $("#ticker-prev-'.$label.'"),
                    nextButton: $("#ticker-next-'.$label.'"),
                    stopButton: $("#ticker-pause-'.$label.'"),
                    startButton: $("#ticker-play-'.$label.'"),
                    start: function() {
                    	$("#timeline_'.$label.' #ticker-pause-'.$label.'").show();
                        $("#timeline_'.$label.' #ticker-play-'.$label.'").hide();
                    },
                    stop: function() {
                    	$("#timeline_'.$label.' #ticker-pause-'.$label.'").hide();
                        $("#timeline_'.$label.' #ticker-play-'.$label.'").show();
                    }
                });';
            if ( ! @$attr['tabable'] && @$attr['filters'] )
                $output .= "
            	/* Filtering */
                $('#timeline_$label .filter span').click(function() {
            		/* fetch the class of the clicked item */
            		var ourClass = $(this).data('filter');
            		
            		/* reset the active class on all the buttons */
            		$('#timeline_$label .filter span').removeClass('active');
            		/* update the active state on our clicked button */
            		$(this).addClass('active');
            		
            		if(ourClass == 'all') {
            			/* show all our items */
            			$('$ticker_id').children('li.sb-item').show();
            		}
            		else {
            			/* hide all elements that don't share ourClass */
            			$('$ticker_id').children('li:not(' + ourClass + ')').fadeOut('fast');
            			/* show all elements that do share ourClass */
            			$('$ticker_id').children('li' + ourClass).fadeIn('fast');
            		}
            		return false;
            	});";
                }
                
                if ( @$attr['slide'] && ! (@$attr['tabable'] && @$attr['position'] == 'normal') ) {
                if ( $location == 'left' || $location == 'right' ){
                    $getsizeof = 'Width';
                    $opener = 'sb-opener';
                    $padding = '';
                } else {
                    $getsizeof = 'Height';
                    $opener = 'sb-heading';
                    $padding = ( @$attr['showheader'] || ($location == 'bottom' && ! @$attr['tabable']) ) ? ' - 30' : '';
                }
                $openid = (@$attr['tabable']) ? "#timeline_$label .sb-tabs li" : "#timeline_$label .$opener";
                $output .= "
                /* slide in/out */
                var padding = $('#timeline_$label').outer$getsizeof();
                padding = parseFloat(padding)$padding;";
                $output .= ( @$attr['autoclose'] ) ? "$('#timeline_$label').animate({ '$location': '-='+padding+'px' }, 'fast' );" : '';
                $output .= "
                $('$openid').click(function(event) {
                    if ( $('#timeline_$label').hasClass('open') ) {
                        if ( $(this).hasClass( 'active' ) ) {
                            $('$openid').removeClass('active');
                            $('#timeline_$label').animate({ '$location': '-='+padding+'px' }, 'slow' ).removeClass('open');
                        } else {
                            $('$openid').removeClass('active');
                            $(this).addClass('active');
                        }
                    } else {
                        $(this).addClass('active');
                        $('#timeline_$label').animate({ '$location': '+='+padding+'px' }, 'slow' ).addClass('open');
                    }
                    event.preventDefault();
                });";
                }
                else { // only for normal tabable
                    $openid = "#timeline_$label .sb-tabs li";
                $output .= "
                $('$openid').click(function(event) {
                    $('$openid').removeClass('active');
                    if ( $('#timeline_$label').hasClass('open') ) {
                        if ( $(this).hasClass( 'active' ) ) {
                            $('#timeline_$label').removeClass('open');
                        } else {
                            $(this).addClass('active');
                        }
                    } else {
                        $(this).addClass('active');
                        $('#timeline_$label').addClass('open');
                    }
                    event.preventDefault();
                });";
                }
                
                $output .= '
            });
        </script>';
        if (@$ticker_id)
            $ticker_id_t = ' '.$ticker_id;
            } elseif ( $is_wall ) {
        if ( ! empty($feeds) ) {
        $itemwidth = (@$attr['itemwidth'] ? $attr['itemwidth'] : $defoption['setting']['itemwidth']);
        $output .= '
    	<script type="text/javascript">
            jQuery(document).ready(function($) {
    			var wall = new freewall("#timeline_'.$label.$ticker_id_t.'");
    			wall.reset({
    				selector: ".sb-item",
                    cellW: function(width) {
                      var cellWidth = '.$itemwidth.';
                      if (width > cellWidth)
                        return cellWidth;
                      else
                        return 180;
                    },
    				cellH: "auto",';
                if (@$attr['gutterX'])
                $output .= '
                    gutterX: '.$attr['gutterX'].',';
                if (@$attr['gutterY'])
                $output .= '
                    gutterY: '.$attr['gutterY'].',';
                if ( ! @$attr['fixSize'])
                $output .= '
                    fixSize: 1,';
                $output .= '
                    animate: '.@$attr['animate'].',
                    delay: '.@$attr['delay'].',
                    rightToLeft: '.@$attr['filter_direction'].',
    				onResize: function() {
    					wall.fitWidth();
    				}
    			});
                
    			$(".filter-label").click(function() {
    				wall.unFilter();
                    $(".filter-label").removeClass("active");
    				var filter = $(this).addClass("active").data("filter");
    				if (filter) {
    					wall.filter(filter);
    				} else {
    					wall.unFilter();
    				}
    			});
                
    			wall.container.find(".sb-item img").load(function() {
    				wall.fitWidth();
    			});
                wall.fitWidth();
            '.$more_output;
        $output .= '
            });
    	</script>';
        }
        } elseif ( $is_timeline ) {
            $output .= '
    	<script type="text/javascript">
            jQuery(document).ready(function($) {
                '.$more_output.'
            });
    	</script>
            ';
        }

            if (@$attr['tabable']) {
        	$output .= '
            <script type="text/javascript">
            jQuery(document).ready(function($) {
               $("#timeline_'.$label.' .sb-tabs").on("click", "li", function() {
                if ( $(this).hasClass( "active" ) ) {
                  feed = $(this).attr("data-feed");
                  nonce = $(this).parent().attr("data-nonce");
                  ';
               $output .= "
                  $('#timeline_".$label." .sb-content ul').html('<p class=\"sb-loading\"><i class=\"sb-icon sb-'+feed+'\"></i></p>');";
               $output .= '
                  $.ajax({
                    type: "post",
                    url: "'.admin_url( 'admin-ajax.php' ).'",
                    data: {action: "sb_tabable", feed: feed, attr: '.$attr_ajax.', nonce: nonce},
                    cache: false
                    })
                    .done(function( response ) {
                        $("#timeline_'.$label.$ticker_id_t.'").html(response);
                        /* rebuild feed ticker */
                        $("'.$ticker_id.'").newsTicker();
                        '.$iframe_output.'
                    })
                    .fail(function() {
                        alert( "Problem reading the feed data!" );
                  });
                }
               });
            });
            </script>';
            }
            
            if (@$iframe) {
            $output .= '
        	<script>
        		jQuery(document).ready(function($) {
        		  '.$iframe_output.'
                });
        	</script>';
            }
            
            if (@$GLOBALS['islive'] && ! $is_feed) {
                $timeinterval = (@$attr['live_interval'] ? intval($attr['live_interval']) * 60000 : 60000); // 60000 = 1 Min
                $stdiv = ($is_wall) ? 'div.sb-item' : 'div.timeline-row';
                $output .= '
            <script type="text/javascript">
            jQuery(document).ready(function($) {
              var nonce = "'.wp_create_nonce( 'liveupdate' ).'";
              setInterval(function(){
                  var stlen = $("#timeline_'.$label.' '.$stdiv.'").length;
                  $.ajax({
                    type: "post",
                    url: "'.admin_url( 'admin-ajax.php' ).'",
                    data: {action: "sb_liveupdate", attr: '.$attr_ajax.', nonce: nonce, results: stlen, label: "'.$label.'"},
                    cache: false,
                    success: function(data) {
                      if (data != "")
                        $("#timeline_'.$label.'").html(data);';
                        if ( $is_wall )
                            $output .= '$("#timeline_'.$label.'").trigger( "resize" );';
                        elseif ( $is_timeline )
                            $output .= '$("#timeline_'.$label.'").trigger( "scroll" );';
                            
                        $output .= $iframe_output.'
                    }
                  });
              }, '.$timeinterval.');
            });
            </script>';
            }
        }
        
        if ( ! $ajax_feed)
            $output .= ($forceCrawl) ? "\t<!-- End Social Board Plugin - cache is disabled. -->\n" : "\t<!-- End Social Board Plugin - cache is enabled - duration: " . $attr['cache'] . " minutes -->\n";
        $output = str_replace( array("\r\n","\r","\t","\n"), '', $output );
        
    	if ( $echo )
    		echo $output;
    	else
    		return $output;
    }

    /**
     * Proper way to enqueue scripts and styles
     */
    function add_styles() {
        wp_enqueue_style( 'colorbox', plugins_url( 'public/css/colorbox/light/colorbox.css', SB_FILE ) );
        wp_enqueue_style( 'timeline', plugins_url( 'public/css/timeline-styles.css', SB_FILE ) );
        wp_enqueue_style( 'lightslider', plugins_url( 'public/css/lightslider.css', SB_FILE ) );
        wp_enqueue_style( 'social-board', plugins_url( 'public/css/styles.css', SB_FILE ), false, SB_VERSION );
    }

	// add some js files
    public function header() {
        wp_enqueue_script( 'jquery' );
        wp_enqueue_script( 'colorbox', plugins_url( 'public/js/jquery.colorbox-min.js', SB_FILE ), array('jquery'));
	}
    
    // function for retrieving data from feeds
    public function sb_get_feed( $feed_key, $i, $key2, $feed_value, $results, $setoption, $sboption, $cache, $forceCrawl = false, $sb_label = null ) {
        $feed_value = trim($feed_value);
        switch ( $feed_key ) {
            case 'facebook':
                $pageresults = 9; // the max results that is possible to fetch from facebook API - for group = 9 for page = 30 - we used 9 to support both
                $stepresults = ceil($results / $pageresults);
                $facebook_access_token = @$setoption['section_facebook']['facebook_access_token'];
                
                if ($datetime_from = @$sboption['facebook_datetime_range']['from'])
                    $since_str = '&since='.strtotime($datetime_from);
                    
                if ($datetime_to = @$sboption['facebook_datetime_range']['to'])
                    $until_str = '&until='.strtotime($datetime_to);
                
                if ($until = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $until_str = '&until='.$until;
                
                $afields = array('id','created_time','updated_time','link','from','name','source','message','description','story','comments','likes','picture','full_picture','object_id','type','status_type');
                // define the feed url
                if ($i == 5) {
                    /* Deprecated
                    // search term or hashtag
                    if ( ! @$since_str)
                        $since_str = '&since='.strtotime("-1 year"); // from last year
                    $feed_url = 'https://graph.facebook.com/v1.0/search?q='.urlencode($feed_value).'&limit=' . $pageresults . $since_str . @$until_str .'&access_token=' . $facebook_access_token;
                    $label = 'https://graph.facebook.com/search?q='.urlencode($feed_value).'&limit=' . $results;
                    */
                }
                else {
                    // Page Feed
                    if ($i == 1) {
                        $feedType = (@$sboption['facebook_pagefeed']) ? $sboption['facebook_pagefeed'] : 'feed';
                    }
                    // Group Feed
                    elseif ($i == 2) {
                        $feedType = 'feed';
                    }
                    elseif ($i == 3) {
                        $feedType = 'photos';
                        $afields[] = 'images';
                    } elseif ($i == 4) {
                        $feedType = 'videos';
                        $afields[] = 'images';
                    }
                    
                    $fields = implode(',', $afields);
                    $feed_url = 'https://graph.facebook.com/v2.3/' . $feed_value . '/' . $feedType . '?limit=' . ( ($i == 2) ? $pageresults : $results ) . @$since_str . @$until_str . '&fields=' . $fields . '&access_token=' . $facebook_access_token;
                    $label = 'https://graph.facebook.com/' . $feed_value . '/' . $feedType . '?limit=' . $results;
                }
                
                // if group feed
                if ($i == 2) {
                    // crawl the feed or read from the cache
                    $get_feed = TRUE;
                    if ( ! $forceCrawl ) {
                        if ( $cache->is_cached($label) ) {
                            $content = $cache->get_cache($label);
                            $get_feed = FALSE;
                        }
                    }
                    if ($get_feed) {
                        $feed = array();
                        for ($i = 1; $i <= $stepresults; $i++) {
                            $content = $cache->do_curl($feed_url);
                            $pagefeed = @json_decode($content);
                            if ( ! empty($pagefeed) ) {
                            $feed[] = $pagefeed->data;
                            if ( count($pagefeed->data) < $pageresults )
                                break;
                            $feed_url = $pagefeed->paging->next;
                            }
                        }
               			if ( ! $forceCrawl )
                            $cache->set_cache($label, json_encode($feed));
                    }
                    else
                        $feed = @json_decode($content);
                }
                else {
                    $content = ( ! $forceCrawl ) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                    if ( $pagefeed = @json_decode($content) )
                        $feed[] = $pagefeed->data;
                }
            break;
            case 'twitter':
                $consumer_key = @trim($setoption['section_twitter']['twitter_api_key']);
                $consumer_secret = @trim($setoption['section_twitter']['twitter_api_secret']);
                $oauth_access_token = @trim($setoption['section_twitter']['twitter_access_token']);
                $oauth_access_token_secret = @trim($setoption['section_twitter']['twitter_access_token_secret']);
                switch($i)
                {
                	case 1:
                        $rest = 'statuses/user_timeline';
                        $params = array(
                            'exclude_replies' => (@$sboption['twitter_feeds']['replies']) ? 'false' : 'true',
                            'screen_name' => $feed_value
                            );
                        if ( ! @$sboption['twitter_feeds']['retweets'])
                            $params['include_rts'] = 'false';
                	break;
                	case 2:
                        $rest = "lists/statuses";
                        if ( is_numeric($feed_value) )
                            $params = array('list_id' => $feed_value);
                        else {
                            $feedvalarr = explode('/', $feed_value);
                            $params = array('owner_screen_name' => $feedvalarr[0], 'slug' => $feedvalarr[1]);
                            if (@$sboption['twitter_feeds']['retweets'])
                                $params['include_rts'] = 'true';
                        }
                	break;
                	case 3:
                        $rest = "search/tweets";
                        $feed_value = urlencode($feed_value);
                        if ( ! @$sboption['twitter_feeds']['retweets'])
                            $feed_value .= ' AND -filter:retweets';
                        $params = array('q' => $feed_value);
                	break;
                }
                $params['count'] = $results;
                
                if ($id_from = @$sboption['twitter_id_range'][0])
                    $params['since_id'] = $id_from;
                    
                if ($id_to = @$sboption['twitter_id_range'][1])
                    $params['max_id'] = $id_to;
                    
                if ($max_id = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $params['max_id'] = $max_id;
        		
                $get_feed = TRUE;
                $label = 'https://api.twitter.com/1.1/'.$rest.'/'.serialize($params);
                if ( ! $forceCrawl ) {
                    if ( $cache->is_cached($label) ) {
                        $content = $cache->get_cache($label);
                        $get_feed = FALSE;
                    }
                }
                if ($get_feed) {
                    if ( ! class_exists( 'TwitterOAuth' ) )
                        require_once('oauth/twitteroauth.php');
                    $auth = new TwitterOAuth($consumer_key, $consumer_secret, $oauth_access_token, $oauth_access_token_secret);
                    $auth->timeout = $this->attr['timeout'];
                    $auth->connecttimeout = $this->attr['timeout'];
                    $auth->decode_json = FALSE;
                    $content = $auth->get( $rest, $params );
                    if ( ! $content ) {
                    	if (@$this->attr['debuglog'])
                            sb_log( 'Twitter error: An error occurs while reading the feed, please check your connection or settings.');
                    }
                    else {
                        $feed = @json_decode($content);
                        if ( isset( $feed->errors ) ) {
                            foreach( $feed->errors as $key => $val ) {
                                if (@$this->attr['debuglog'])
                                    sb_log( 'Twitter error: '.$val->message.' - ' . $rest);
                            }
                            $feed = null;
                        }
                    }
           			if ( ! $forceCrawl )
                        $cache->set_cache($label, $content);
                }
                else
                    $feed = @json_decode($content);
    		break;
    		case 'google':
    			$google_api_key = @$setoption['section_google']['google_api_key'];
                if ($nextPageToken = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $pageToken = '&pageToken='.$nextPageToken;
                $feed_url = 'https://www.googleapis.com/plus/v1/people/' . $feed_value . '/activities/public?maxResults=' . $results . @$pageToken . '&key=' . $google_api_key;
                $content = ( ! $forceCrawl ) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $feed = @json_decode($content);
                if (@$feed->error) {
                    $feed = null;
                }
    		break;
            case 'flickr':
                $flickr_api_key = @$setoption['section_flickr']['flickr_api_key'];
                if ($nextPage = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $pageToken = '&page='.$nextPage;
                if ($i == 1) {
                    $feedType = 'flickr.people.getPublicPhotos';
                    $feedID = '&user_id='.$feed_value;
                } elseif ($i == 2) {
                    $feedType = 'flickr.groups.pools.getPhotos';
                    $feedID = '&group_id='.$feed_value;
                }
                $feed_url = 'https://api.flickr.com/services/rest/?method='.$feedType.'&api_key='.$flickr_api_key . $feedID . '&per_page=' . $results . @$pageToken . '&extras=date_upload,date_taken,owner_name,icon_server,tags,views&format=json&nojsoncallback=1';
                $content = ( ! $forceCrawl ) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $feed = @json_decode($content);
    		break;
            case 'delicious':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                    $feed_url = "http://feeds.delicious.com/v2/json/" . $feed_value . '?count=' . $results;
                    $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                    $feed = @json_decode($content);
                }
            break;
    		case 'pinterest':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                    $rss_uri = ($i == 1) ? 'feed.rss' : 'rss';
                    $feed_url = "https://www.pinterest.com/" . $feed_value . "/$rss_uri";
                    $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                    $feed = @simplexml_load_string($content);
                }
    		break;
    		case 'instagram':
                $instagram_access_token = @$setoption['section_instagram']['instagram_access_token'];
                $max_str = 'max_id';
                $feed_url = '';
                if ($i == 1) {
                    $user_url = 'https://api.instagram.com/v1/users/search?q=' . $feed_value .'&access_token=' . $instagram_access_token;
                    $user_content = ( ! $forceCrawl) ? $cache->get_data($user_url, $user_url) : @$cache->do_curl($user_url);
                    if ($user_content) {
                        $user_feed = @json_decode($user_content);
                        if ( ! empty($user_feed->data) )
                            $feed_url = 'https://api.instagram.com/v1/users/' . $user_feed->data[0]->id . '/media/recent?count=' . $results;
                    }
                } elseif ($i == 2) {
                    $feed_url = 'https://api.instagram.com/v1/tags/' . urlencode($feed_value) . '/media/recent?count=' . $results;
                    $max_str = 'max_tag_id';
                } elseif ($i == 3) {
                    $feed_url = 'https://api.instagram.com/v1/locations/' . $feed_value . '/media/recent?access_token=' . $instagram_access_token;
                } elseif ($i == 4) {
                    $coordinates = explode(',', $feed_value);
                    $feed_url = 'https://api.instagram.com/v1/media/search?lat=' . $coordinates[0] . '&lng=' . $coordinates[1] . '&distance=' . $coordinates[2];
                    $max_str = 'max_timestamp';
                }
                $feed_url .= '&access_token=' . $instagram_access_token;
                
                if (@$feed_url) {
                    if ($next_max_id = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                        $feed_url .= '&'. $max_str .'='.$next_max_id;
                    
                    $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                    $feed = @json_decode($content);
                }
    		break;
    		case 'youtube':
                $google_api_key = @$setoption['section_google']['google_api_key'];
                if ($nextPageToken = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $pageToken = '&pageToken='.$nextPageToken;
                switch($i)
                {
                	case 1:
                    case 4:
                        $channel_filter = ($i == 1) ? 'forUsername' : 'id';
                        $user_url = 'https://www.googleapis.com/youtube/v3/channels?part=contentDetails&'.$channel_filter.'=' . $feed_value .'&key=' . $google_api_key;
                        $user_content = ( ! $forceCrawl) ? $cache->get_data($user_url, $user_url) : @$cache->do_curl($user_url);
                        if ($user_content) {
                            $user_feed = @json_decode($user_content);
                            if (@$user_feed->items[0])
                                $feed_url = 'https://www.googleapis.com/youtube/v3/playlistItems?playlistId=' . $user_feed->items[0]->contentDetails->relatedPlaylists->uploads;
                        }
                    break;
                    case 2:
                        $feed_url = 'https://www.googleapis.com/youtube/v3/playlistItems?playlistId=' . $feed_value;
                    break;
                    case 3:
                        $feed_url = 'https://www.googleapis.com/youtube/v3/search?q=' . rawurlencode($feed_value);
                    break;
                }
                if ($results > 50) $results = 50;
                if (@$feed_url) {
                    $feed_url .= '&part=snippet&maxResults=' . $results . @$pageToken . '&key=' . $google_api_key;
                    $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                    $feed = @json_decode($content);
                }
    		break;
    		case 'vimeo':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                $requests = "videos,likes,appears_in,all_videos,subscriptions,albums,channels,groups";
                $feedtypes = explode(',', $requests);
                foreach ($feedtypes as $type) {
                    if (@$sboption['vimeo_feeds'][$type]) {
                        $feed_url = 'https://vimeo.com/api/v2/' . $feed_value . '/' . $type . ".json";
                        $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                        if ( $data = @json_decode($content) )
                            $feed[$type] = $data;
                    }
                }
                }
    		break;
    		case 'tumblr':
                $tumblr_api_key = @$setoption['section_tumblr']['tumblr_api_key'];
                $feed_url = "https://api.tumblr.com/v2/blog/" . $feed_value . ".tumblr.com/posts?api_key={$tumblr_api_key}&limit=$results";
                if ($posts_start = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $feed_url .= '&offset='.$posts_start;
                    
                $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $feed = @json_decode($content);
            break;
    		case 'stumbleupon':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                $feedtypes = array('comments', 'likes');
                foreach ($feedtypes as $type) {
                    if (@$sboption['stumbleupon_feeds'][$type]) {
                        $feed_url = "http://www.stumbleupon.com/rss/stumbler/" . $feed_value . "/" . $type;
                        $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                        if ( $data = @simplexml_load_string($content, 'SimpleXMLElement', LIBXML_NOCDATA) )
                            $feed[$type] = $data;
                    }
                }
                }
    		break;
    		case 'deviantart':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                $feed_url = "https://backend.deviantart.com/rss.xml?type=deviation&q=by%3A" . $feed_value . "+sort%3Atime+meta%3Aall";
                $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $feed = @simplexml_load_string($content);
                }
    		break;
            case 'rss':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                    $content = ( ! $forceCrawl) ? $cache->get_data($feed_value, $feed_value) : $cache->do_curl($feed_value);
                    $feed = @simplexml_load_string($content);
                }
            break;
            case 'soundcloud':
                if ( empty($_SESSION[$sb_label]['loadcrawl']) ) {
                $soundcloud_client_id = @$setoption['section_soundcloud']['soundcloud_client_id'];
                $feed_url = "http://api.soundcloud.com/users/$feed_value/tracks.json?client_id=" . $soundcloud_client_id . "&limit=$results";
                $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $feed = @json_decode($content);
                }
            break;
            case 'vk':
                $pagefeed = (@$sboption['vk_pagefeed']) ? $sboption['vk_pagefeed'] : 'all';
                $wall_by = ($i == 1) ? 'domain' : 'owner_id';
                $feed_url = "https://api.vk.com/method/wall.get?v=5.34&{$wall_by}={$feed_value}&count={$results}&extended=1&lang=en&filter={$pagefeed}";
                if ($offset = @$_SESSION[$sb_label]['loadcrawl'][$feed_key.$i.$key2])
                    $feed_url .= '&offset='.$offset;
                else
                    $offset = 0;
                $content = ( ! $forceCrawl) ? $cache->get_data($feed_url, $feed_url) : $cache->do_curl($feed_url);
                $content = @mb_convert_encoding($content, "UTF-8", "auto");
                $feed = @json_decode($content);
                if (is_object($feed))
                    $feed->offset = $offset;
            break;
    	}
        
    	return @$feed;
    }
    
    /**
     * [social_board id="" type=""]
     */
    public static function social_board_shortcode( $atts ) {
        if (@$atts['network']) {
            $network2 = explode('{|}', $atts['network']);
            foreach ($network2 as $net2) {
                $network3 = explode('{/}', $net2);
                $network4 = explode('{;}', $network3[1]);
                
                $net5 = array();
                foreach ($network4 as $net4) {
                    $network5 = explode('{:}', $net4);
                    if (stristr($network5[0], '_id_') === FALSE) {
                        $network6 = $network5[1];
                        
                        if (stristr($network5[0], '_output') == TRUE) {
                            $network6 = ss_explode($network6);
                        }
                    } else {
                        $network6 = explode('{,}', $network5[1]);
                    }
                    $net5[$network5[0]] = $network6;
                }
                
                $net3[$network3[0]] = $net5;
            }
            $atts['network'] = $net3;
        }
        $echo = (@$atts['echo']) ? true : false;
        $sb = new SocialBoard();
        return $sb->init( $atts, $echo );
    }
    
    // create time string for sorting and applying pinning options
    private function make_timestr($time, $link) {
        $timestr = ( is_numeric($time) ) ? $time : strtotime($time);
        if ( ! empty($this->sboption['pins']) ) {
            $dkey = array_search($link, $this->sboption['pins']);
            if ($dkey !== false)
                $timestr = strtotime("+$dkey day");
        }
        return $timestr.'-'.$GLOBALS['order']++;
    }
    
    // applying board items removal
    private function make_remove($link) {
        if ( ! empty($this->sboption['remove']) ) {
            if ( in_array($link, $this->sboption['remove']) )
                return false;
        }
        return true;
    }
    
    /**
     * Word Limiter
     *
     * Limits a string to X number of words.
     *
     * @param   $end_char   the end character. Usually an ellipsis
     */
    function word_limiter($str, $url = '', $comment = false) {
        $limit = ($comment) ? @$this->attr['commentwords'] : @$this->attr['words'];
        $end_char = '...';
        
        $str = trim( strip_tags($str) );
    	if ($str == '')
    	{
    		return $str;
    	}
        
        if (str_word_count_utf8($str) < $limit) {
            $str = $this->format_text($str);
            return $str;
        }
        
    	preg_match('/^\s*+(?:\S++\s*+){1,'.(int) $limit.'}/', $str, $matches);
        if (strlen($str) == strlen($matches[0]))
    	{
    		$end_char = '';
    	}
        $str = $this->format_text($matches[0]);
    	if (@$this->attr['readmore'] && $url)
            $end_char = ' <a href="' . $url . '"'.$this->target.' style="font-size: large;">' . $end_char . '</a>';
            
        return $str.$end_char;
    }
    
    // Title Limiter (limits the title of each item to X number of words)
    function title_limiter($str, $url = '') {
        $end_char = '...';
        $limit = (@$this->attr['titles']) ? $this->attr['titles'] : 15;
        $str = strip_tags($str);

    	if (trim($str) == '')
    	{
    		return $str;
    	}
        
        if (str_word_count_utf8($str) < $limit) {
            return $str;
        }

    	preg_match('/^\s*+(?:\S++\s*+){1,'.(int) $limit.'}/', $str, $matches);

        if (strlen($str) == strlen($matches[0]))
    	{
    		$end_char = '';
    	}

        return rtrim($matches[0]).$end_char;
    }
    
    function format_text($str) {
        // make the urls hyper links
        $links = array();
        if ( $matches = sb_geturls($str) ) {
            foreach ($matches as $url)
                $links[] = '<a href="'.$url.'"'.$this->target.'>'.$url.'</a>';
            $str = str_replace($matches, $links, $str);
        }
        return nl2br($str);
    }
    
    function vk_get_photo($photo){
        foreach ($photo as $ikey => $iphoto) {
            if (stristr($ikey, 'photo_') == TRUE) {
                $source = $iphoto;
            }
        }
        return @$source;
    }
} // end class

// create the ajax callback for tabable widget
add_action("wp_ajax_sb_tabable", "sb_tabable");
add_action("wp_ajax_nopriv_sb_tabable", "sb_tabable");
function sb_tabable() {

    if ( ! wp_verify_nonce( $_REQUEST['nonce'], "tabable")) {
        exit("No naughty business please!");
    }

    if ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        $sb = new SocialBoard();
        $sb->init( $_REQUEST['attr'], true, null, array( $_REQUEST['feed'] ) );
    }
    else {
        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }
    
    die();
}

// create the ajax callback for load more
add_action("wp_ajax_sb_loadmore", "sb_loadmore");
add_action("wp_ajax_nopriv_sb_loadmore", "sb_loadmore");
function sb_loadmore() {

    if ( ! wp_verify_nonce( $_REQUEST['nonce'], "loadmore")) {
        exit("No naughty business please!");
    }

    if ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        $sb = new SocialBoard();
        $sb->init( $_REQUEST['attr'], true, null, 'all', $_SESSION[$_REQUEST['label']]['loadmore'] );
    }
    else {
        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }
    
    die();
}

// create the ajax callback for live update
add_action("wp_ajax_sb_liveupdate", "sb_liveupdate");
add_action("wp_ajax_nopriv_sb_liveupdate", "sb_liveupdate");
function sb_liveupdate() {

    if ( ! wp_verify_nonce( $_REQUEST['nonce'], "liveupdate")) {
        exit("No naughty business please!");
    }

    if ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        $args = array('liveresults' => @$_REQUEST['results']);
        $sb = new SocialBoard();
        $sb->init( $_REQUEST['attr'], true, $args, 'all', array() );
    }
    else {
        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }
    
    die();
}

// Word counter function
function str_word_count_utf8($str) {
    return count(preg_split('~[^\p{L}\p{N}\']+~u',$str));
}

// Friendly dates (i.e. "2 days ago")
function sb_friendly_date( $date ) {
	
	// Make sure the server is using the right time zone
	if ( get_option( 'timezone_string' ) && strpos( get_option( 'timezone_string' ), 'UTC' ) === false )
		date_default_timezone_set( get_option( 'timezone_string' ) );
	
	// Get the time difference in seconds
	$post_time = ( is_numeric($date) ) ? $date : strtotime( $date );
	$current_time = time();
	$time_difference = $current_time - $post_time;
	
	// Seconds per...
	$minute = 60;
	$hour = 3600;
	$day = 86400;
	$week = $day * 7;
	$month = $day * 31;
	$year = $day * 366;
	
	// if over 3 years
	if ( $time_difference > $year * 3 ) {
		$friendly_date = __( 'a long while ago', 'social-board' );
	}
	
	// if over 2 years
	else if ( $time_difference > $year * 2 ) {
		$friendly_date = __( 'over 2 years ago', 'social-board' );
	}
	
	// if over 1 year
	else if ( $time_difference > $year ) {
		$friendly_date = __( 'over a year ago', 'social-board' );
	}
	
	// if over 11 months
	else if ( $time_difference >= $month * 11 ) {
		$friendly_date = __( 'about a year ago', 'social-board' );
	}
	
	// if over 2 months
	else if ( $time_difference >= $month * 2 ) {
		$months = (int) $time_difference / $month;
		$friendly_date = sprintf( __( '%d months ago', 'social-board' ), $months );
	}
	
	// if over 4 weeks ago
	else if ( $time_difference > $week * 4 ) {
		$friendly_date = __( 'last month', 'social-board' );
	}
	
	// if over 3 weeks ago
	else if ( $time_difference > $week * 3 ) {
		$friendly_date = __( '3 weeks ago', 'social-board' );
	}
	
	// if over 2 weeks ago
	else if ( $time_difference > $week * 2 ) {
		$friendly_date = __( '2 weeks ago', 'social-board' );
	}
	
	// if equal to or more than a week ago
	else if ( $time_difference >= $day * 7 ) {
		$friendly_date = __( 'last week', 'social-board' );
	}
	
	// if equal to or more than 2 days ago
	else if ( $time_difference >= $day * 2 ) {
		$days = (int) $time_difference / $day;
		$friendly_date = sprintf( __( '%d days ago', 'social-board' ), $days );
	}
	
	// if equal to or more than 1 day ago
	else if ( $time_difference >= $day ) {
		$friendly_date = __( 'yesterday', 'social-board' );
	}
	
	// 2 or more hours ago
	else if ( $time_difference >= $hour * 2 ) {
		$hours = (int) $time_difference / $hour;
		$friendly_date = sprintf( __( '%d hours ago', 'social-board' ), $hours );
	}
	
	// 1 hour ago
	else if ( $time_difference >= $hour ) {
		$friendly_date = __( 'an hour ago', 'social-board' );
	}
	
	// 2–59 minutes ago
	else if ( $time_difference >= $minute * 2 ) {
		$minutes = (int) $time_difference / $minute;
		$friendly_date = sprintf( __( '%d minutes ago', 'social-board' ), $minutes );
	}
	
	else {
		$friendly_date = __( 'just now', 'social-board' );
	}
	
	// HTML 5 FTW
	return '<time title="' . date_i18n( get_option( 'date_format' ), $post_time ) . '" datetime="' . date( 'c', $post_time ) . '">' . ucfirst( $friendly_date ) . '</time>';
}

// i18n dates
function sb_i18n_date( $date, $format ) {
    $post_time = ( is_numeric($date) ) ? $date : strtotime( $date );
    return date_i18n( $format, $post_time );
}

function ss_explode( $output = array() ) {
    if ( ! empty($output) ) {
        $outputArr = explode(',', str_replace(' ', '', $output) );
        foreach ($outputArr as $val)
            $out[$val] = true;
        
        return $out;
    }
    return false;
}

function sb_options( $post_id )
{
    if ( ! is_numeric($post_id) ) {
        $args = array(
            'meta_key' => 'classname',
            'meta_value' => $post_id,
            'post_type' => 'sb_themes',
            'posts_per_page' => 999999
        );
        $posts = get_posts($args);
        $post_id = $posts[0]->ID;
    }
    
    // 1. To retrieve the meta box data - get_post_meta( $post->ID ) will return an array of all the meta field values.
    // or if you know the field id of the value you want, you can do $value = get_post_meta( $post->ID, $field_id, true );
    $postData = array();
    foreach( ( array ) get_post_custom_keys( $post_id ) as $sKey ) {    // This way, array will be unserialized; easier to view.
        $postData[ $sKey ] = get_post_meta( $post_id, $sKey, true );
    }
    
    return $postData;
}

// display different items according to user selections in admin widget
function sb_admin_inline_script() {
    if ( wp_script_is( 'jquery', 'done' ) ) {
    
    if ( @$sb_widget = get_option('widget_sb_widget') ){
    ?>
    <script type="text/javascript">
    var sb_widget_updated = function($) {
        <?php foreach ($sb_widget as $widgetKey => $widgetItem) {
        if ( is_int($widgetKey) ) {
            ?>
            var widgetElement = '[name="widget-sb_widget[<?php echo $widgetKey; ?>]';
            <?php
            if ($widgetItem['position'] == 'normal'){ ?>
                $(widgetElement+'[width]"]').val('');
                $(widgetElement+'[location]"]').closest("tr").hide();
                $(widgetElement+'[slide]"]').closest("tr").hide();
                $(widgetElement+'[autoclose]"]').closest("tr").hide();
            <?php } ?>
            var widget = $( '[id$=sb_widget-<?php echo $widgetKey; ?>]' );
            sb_widget_update(null, widget);
        <?php }
        } ?>
    }
    
    jQuery(document).ready(function($) {
        sb_widget_updated($);
    });
    
    function sb_widget_update(e, widget) {
        // selective
        widget.on('change', 'input[name$="[position]"]', function() {
            if ( jQuery(this).val() == 'normal' ) {
                widget.find('input[name$="[width]"]').val('');
                widget.find('select[name$="[location]"]').closest("tr").fadeOut('fast');
                widget.find('input[name$="[slide]"]').closest("tr").fadeOut('fast');
                widget.find('input[name$="[autoclose]"]').closest("tr").fadeOut('fast');
            } else {
                widget.find('input[name$="[width]"]').val('250');
                widget.find('select[name$="[location]"]').closest("tr").fadeIn('fast');
                widget.find('input[name$="[tabable]"]').closest("tr").fadeIn('fast');
                widget.find('input[name$="[slide]"]').closest("tr").fadeIn('fast');
                widget.find('input[name$="[autoclose]"]').closest("tr").fadeIn('fast');
            }
        });
        
        widget.on('change', 'select[name$="[location]"]', function() {
            var ischecked = true;
            if ( jQuery( this ).val() == 'sb-left' || jQuery( this ).val() == 'sb-right' ) {
                var ischecked = false;
            }
            widget.find('input[name$="[showheader]"]').prop('checked', ischecked);
        });
        widget.on('change', 'input[name$="[slide]"]', function() {
            var ischecked = jQuery( this ).prop('checked');
            widget.find('input[name$="[autoclose]"]').prop('disabled', ! ischecked);
        });
        widget.on('change', 'input[name$="[carousel]"]', function() {
            var ischecked = jQuery( this ).prop('checked');
            widget.find('input[name$="[tabable]"]').prop('disabled', ischecked);
            widget.find('input[name$="[override_settings]"]').val( (ischecked) ? 'cs_item=1&slideMove=1' : '' );
        });
    }

    // "widget" represents jQuery object of the affected widget's DOM element
    jQuery(document).on('widget-updated', sb_widget_update);
    jQuery(document).on('widget-added', sb_widget_update);
    </script>
    <?php } ?>
    
    <script type="text/javascript">
    // clear cache
    jQuery(document).ready(function($) {
       $("#sb-clearcache").live("click", function() {
          nonce = $(this).attr("data-nonce");
          log = $(this).attr("data-log");
          var msgid = (log) ? 'clearlog' : 'clearcache';
          $('#sb-'+msgid+'-msg').html('<span class="sb-loading"></span>');
          $.ajax({
            type: "post",
            url: "<?php echo admin_url( 'admin-ajax.php' ); ?>",
            data: {action: "sb_clearcache", nonce: nonce, log: log},
            cache: false
            })
            .done(function( response ) {
                $("#sb-"+msgid+"-msg").html(response);
            })
            .fail(function() {
                alert( "Problem cleaning the cache!" );
          });
       });
    });
    </script>
    <?php
    }
}
add_filter('admin_footer', 'sb_admin_inline_script');

// create the ajax callback for clear cache
add_action("wp_ajax_sb_clearcache", "sb_clearcache");
add_action("wp_ajax_nopriv_sb_clearcache", "sb_clearcache");
function sb_clearcache() {

    if ( ! wp_verify_nonce( $_REQUEST['nonce'], "clearcache")) {
        exit("No naughty business please!");
    }

    if ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        // delete cached files
        if (@$_REQUEST['log']) {
            $file = SB_DIRNAME . '/sb.log';
            @unlink($file);
        } else {
            $path = "/cache/";
            if ( $cachefiles = @glob(SB_DIRNAME . $path ."*.cache*") ) {
                foreach($cachefiles as $file) {
                    @unlink($file); // Delete only .cache files through the loop
                }
            }
        }
        $cache = (@$_REQUEST['log']) ? 'Log' : 'Cache';
        echo '<span style="color:green;">'.$cache.' cleared successfully.</span>';
    }
    else {
        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }
    
    die();
}

// Plugin activation
function sb_activate() {
    $version = get_option("sb_version");
    if ( ! $version) {
        add_option("sb_version", SB_VERSION, '', 'no');
        
        require_once SB_DIRNAME . "/admin/SB_Install.php";
        sb_data_insert();
    }
    elseif (version_compare($version, SB_VERSION, '<')) {
        update_option("sb_version", SB_VERSION);
        
        require_once SB_DIRNAME . "/admin/SB_Install.php";
        sb_data_update($version);
    }
}
register_activation_hook(__FILE__, 'sb_activate');

if (!isset($_GET['action']) || $_GET['action'] != 'deactivate') {
    add_action('admin_init', 'sb_activate');
}

// hex to rgb numerical converter for color styling
function sb_hex2rgb($hex, $str = true) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   } 
   // returns the rgb values separated by commas OR returns an array with the rgb values
   $rgb = ($str) ? "$r, $g, $b" : array($r, $g, $b);
   return $rgb;
}

// get all URLs from string
function sb_geturls($string) {
    $regex = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
    preg_match_all($regex, $string, $matches);
    return ($matches[0]);
}

function sb_log($value) {
    // Create if not exists
    if ( ! file_exists(SB_LOGFILE)) {
        $fp = fopen(SB_LOGFILE, 'w');
        fclose($fp);
    }
    SB_AdminPageFramework_Debug::log( $value, SB_LOGFILE );
}

// modify widget
add_filter('widget_display_callback', 'sb_widget_custom_display', 10, 3);
function sb_widget_custom_display($instance, $widget, $args) {
    $instance['type'] = 'feed';
    
    if (@$instance['override_settings']) {
        parse_str($instance['override_settings'], $aOverride);
        $instance = array_merge($aOverride, $instance);
        unset($instance['override_settings']);
    }
    
    // remove widget header if required
    $instance['label'] = $instance['title'];
    if ( @$instance['position'] == 'sticky' || @$instance['showheader'] ) {
        unset($instance['title']);
    }
    
    if ( @$instance['position'] == 'sticky' ) {
        // remove from sidebar if is sticky
        $sb = new SocialBoard();
        $sb->attr = $instance;
        $sb->args = $args;
        add_action( 'wp_footer', array(&$sb, 'run') );
        
        return false;
    }
    else
        return $instance;
}

// function for using in template files
function social_board( $atts ) {
    $sb = new SocialBoard();
    return $sb->init( $atts, false );
}

// register the plugin for the first time
new SocialBoard();

?>