<?php



/**

 * WordPress Social Board 2.5

 * Copyright 2014 Axent Media (axentmedia@gmail.com)

 */



// create a custom post type for social boards manipulation options

class SB_MetaBox_Social_Boards_Manipulate extends SB_AdminPageFramework_MetaBox {



    /*

     * ( optional ) Use the setUp() method to define settings of this meta box.

     */

    public function setUp() {

        

        /*

         * ( optional ) Adds setting fields into the meta box.

         */

        $this->addSettingFields(

            array(

                'field_id' => 'pins',

                'title' => __( 'Pinned Items', 'social-board-admin' ),

                'type' => 'text',

                'repeatable' => true,

                'description' => __( 'This section will allow you to pin/stick an item on top of the Social Board. Enter the links of social items that you are going to pin on top of the Social Board - Each link in a new line.', 'social-board-admin' ),

                'attributes' => array(

                    'style' => "max-width: 180px;"

                )

            ),

            array(

                'field_id' => 'remove',

                'title' => __( 'Remove Items', 'social-board-admin' ),

                'type' => 'text',

                'repeatable' => true,

                'description' => __( 'Enter the links of social items that you are going to remove from the Social Board - Each link in a new line.', 'social-board-admin' ),

                'attributes' => array(

                    'style' => "max-width: 180px;"

                )

            )

        );

    }

    

    public function do_SB_MetaBox_Social_Boards_Manipulate() { // do_{instantiated class name}

        echo '<a href="'. SB_DOCS . '#manipulation" target="_blank">Read the documentation</a> for more details.';

    }

}