<?php



/**

 * WordPress Social Board 2.5

 * Copyright 2014 Axent Media (axentmedia@gmail.com)

 */



// Create a custom post type for boards - this class deals with front-end components so checking with is_admin() is not necessary.

include( SB_DIRNAME . '/admin/SB_Social_Boards.php' );

new SB_Social_Boards(

    'sb_posts',          // the post type slug

    null,                // the argument array. Here null is passed because it is defined inside the class.

    SB_FILE,             // the caller script path.

    'social-board-admin' // the text domain.

);



// Create a custom post type for themes

include( SB_DIRNAME . '/admin/SB_Themes.php' );

new SB_Themes(

    'sb_themes',         // the post type slug

    null,                // the argument array. Here null is passed because it is defined inside the class.

    SB_FILE,             // the caller script path.

    'social-board-admin' // the text domain.

);



// Create widgets - this class also deals with front-end components so no need to check with is_admin().

include( SB_DIRNAME . '/admin/SB_Widget.php' );

new SB_Widget( __( 'Social Board', 'social-board-admin' ) ); // the widget title



// Create admin pages.

if ( is_admin() ) {

    add_action( 'admin_enqueue_scripts', 'load_admin_style' );

    

    // Create meta boxes with form fields that appear in post definition pages (where you create a post) of the given post type.

    include( SB_DIRNAME . '/admin/SB_MetaBox_Social_Boards.php' );

    new SB_MetaBox_Social_Boards(

        'posts_metabox',                                     // meta box ID

        __( 'Social Board Configurations', 'social-board-admin' ), // title

        array( 'sb_posts' ),                                 // post type slugs: post, page, etc - setting multiple slugs is possible

        'normal',                                            // context (what kind of metabox this is)

        'default'                                            // priority

    );

    

    // Create meta boxes for manipulation section

    include( SB_DIRNAME . '/admin/SB_MetaBox_Social_Boards_Manipulate.php' );

    new SB_MetaBox_Social_Boards_Manipulate(

        'sb_metabox_social_boards_manipulate',

        __( 'Manipulation', 'social-board-admin' ),

        array( 'sb_posts' ),

        'side',

        'default'

    );

    

    // Create an admin sidebar in Manage Boards page

    include( SB_DIRNAME . '/admin/SB_MetaBox_Social_Boards_Side.php' );

    new SB_MetaBox_Social_Boards_Side(

        'sb_metabox_social_boards_side',

        __( 'Add to your website?', 'social-board-admin' ),

        array( 'sb_posts' ),

        'side',

        'default'

    );

    

    // Create Manage Themes page

    include( SB_DIRNAME . '/admin/SB_MetaBox_Themes.php' );

    new SB_MetaBox_Themes(

        'themes_metabox',

        __( 'Theme Settings', 'social-board-admin' ),

        array( 'sb_themes' ),

        'normal',

        'default'

    );

    

    // Create an example page group and add sub-pages including a page with the slug 'sb_settings'.

    include( SB_DIRNAME . '/admin/SB_Settings_Page.php' ); // Include the basic usage example that creates a root page and its sub-pages.

    new SB_Settings_Page(

        null,                       // the option key

        SB_FILE,                    // the caller script path.

        'manage_options',           // the default capability

        'social-board-admin'        // the text domain

    );

}



function load_admin_style() {

    wp_enqueue_style( 'social-board-admin', plugins_url( 'public/css/admin-styles.css', SB_FILE ), false, SB_VERSION );

}



// load cache system

include( SB_DIRNAME . '/library/SimpleCache.php' );



// grab the posts with type social boards

function _getPostTitles( $sPostTypeSlug ) {

    

    $_aArgs         = array(

        'post_type' => $sPostTypeSlug,

    	'orderby' => 'ID',

    	'order'   => 'ASC'

    );

    $_oResults      = new WP_Query( $_aArgs );

    $_aPostTitles   = array();

    foreach( $_oResults->posts as $_iIndex => $_oPost ) {

        $_aPostTitles[ $_oPost->ID ] = $_oPost->post_title;

    }

    if ( empty($_aPostTitles) ) {

        $sPostLabel = ($sPostTypeSlug == 'sb_posts') ? 'Social Board' : 'Theme';

        $_aPostTitles[''] = '-- There is no '.$sPostLabel.' created --';

    }

    return $_aPostTitles;

}



// grab the layout files

function _getFileTitles( $path = '/layout/' ) {

    $_aFileTitles = array();

    if ($handle = opendir( SB_DIRNAME . $path )) {

        while($file = readdir($handle)) {

            if ($file !== '.' && $file !== '..')

            {

                $finfo = pathinfo($file);

                if ( $finfo['extension'] == 'php' )

                    $_aFileTitles[$finfo['filename']] = $finfo['filename'];

            }

        }

        closedir($handle);

    }

    if ( empty($_aFileTitles) ) {

        $_aFileTitles[''] = '-- There is no layout created --';

    }

    return $_aFileTitles;

}