<?php

namespace AmeliaBooking\Application\Commands\Booking\Appointment;

use AmeliaBooking\Application\Commands\CommandHandler;
use AmeliaBooking\Application\Commands\CommandResult;
use AmeliaBooking\Domain\Common\Exceptions\InvalidArgumentException;
use AmeliaBooking\Domain\Entity\Bookable\Service\Service;
use AmeliaBooking\Domain\Entity\Booking\Appointment\Appointment;
use AmeliaBooking\Domain\Entity\Booking\Appointment\CustomerBooking;
use AmeliaBooking\Domain\Entity\Entities;
use AmeliaBooking\Domain\Services\DateTime\DateTimeService;
use AmeliaBooking\Domain\Services\Reservation\ReservationServiceInterface;
use Eluceo\iCal\Component\Calendar;
use Eluceo\iCal\Component\Event;

/**
 * Class GetIcsCommandHandler
 *
 * @package AmeliaBooking\Application\Commands\Booking\Appointment
 */
class GetIcsCommandHandler extends CommandHandler
{
    /**
     * @param GetIcsCommand $command
     *
     * @return CommandResult
     * @throws \UnexpectedValueException
     * @throws \Slim\Exception\ContainerValueNotFoundException
     * @throws InvalidArgumentException
     * @throws \Interop\Container\Exception\ContainerException
     * @throws \AmeliaBooking\Infrastructure\Common\Exceptions\QueryExecutionException
     */
    public function handle(GetIcsCommand $command)
    {
        $result = new CommandResult();

        $type = $command->getField('params')['type'] ?: Entities::APPOINTMENT;

        /** @var ReservationServiceInterface $reservationService */
        $reservationService = $this->container->get('application.reservation.service')->get($type);

        /** @var Appointment|Event $reservation */
        $reservation = $reservationService->getReservationByBookingId((int)$command->getArg('id'));

        /** @var CustomerBooking $booking */
        $booking = $reservation->getBookings()->getItem(
            (int)$command->getArg('id')
        );

        /** @var Service|Event $reservation */
        $bookable = $reservationService->getBookable($reservation->toArray());

        $periods = $reservationService->getBookingPeriods($reservation, $booking, $bookable);

        $vCalendar = new Calendar(AMELIA_URL);

        foreach ($periods as $period) {
            $vEvent = new Event();

            $vEvent
                ->setDtStart(DateTimeService::getCustomDateTimeObjectInUtc(
                    DateTimeService::getCustomDateTimeObject(
                        $period['start']
                    )->format('Y-m-d H:i:s')
                ))
                ->setDtEnd(DateTimeService::getCustomDateTimeObjectInUtc(
                    DateTimeService::getCustomDateTimeObject(
                        $period['end']
                    )->format('Y-m-d H:i:s')
                ))
                ->setSummary($bookable->getName()->getValue());

            $vCalendar->addComponent($vEvent);
        }

        $result->setAttachment(true);

        $result->setIcs(true);

        echo $vCalendar->render();

        return $result;
    }
}
